/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.algcomparison.algorithm.Algorithms;
import edu.cmu.tetrad.algcomparison.algorithm.ExternalAlgorithm;
import edu.cmu.tetrad.algcomparison.algorithm.MultiDataSetAlgorithm;
import edu.cmu.tetrad.algcomparison.independence.FisherZ;
import edu.cmu.tetrad.algcomparison.independence.IndependenceWrapper;
import edu.cmu.tetrad.algcomparison.score.BdeuScore;
import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.algcomparison.simulation.Simulation;
import edu.cmu.tetrad.algcomparison.simulation.Simulations;
import edu.cmu.tetrad.algcomparison.statistic.ElapsedCpuTime;
import edu.cmu.tetrad.algcomparison.statistic.ParameterColumn;
import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.algcomparison.statistic.Statistics;
import edu.cmu.tetrad.algcomparison.utils.HasKnowledge;
import edu.cmu.tetrad.algcomparison.utils.HasParameterValues;
import edu.cmu.tetrad.algcomparison.utils.HasParameters;
import edu.cmu.tetrad.algcomparison.utils.TakesExternalGraph;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.DataWriter;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.simulation.LoadDataAndGraphs;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphSaveLoadUtils;
import edu.cmu.tetrad.graph.GraphTransforms;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.CombinationGenerator;
import edu.cmu.tetrad.util.Experimental;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.cmu.tetrad.util.ParamDescription;
import edu.cmu.tetrad.util.ParamDescriptions;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.StatUtils;
import edu.cmu.tetrad.util.TextTable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.math3.util.FastMath;
import org.reflections.Reflections;

public class TimeoutComparison {
    private static final DateFormat DF = new SimpleDateFormat("EEE, MMMM dd, yyyy hh:mm:ss a");
    private boolean[] graphTypeUsed;
    private PrintStream out;
    private boolean tabDelimitedTables;
    private boolean saveGraphs;
    private boolean copyData;
    private boolean showSimulationIndices;
    private boolean showAlgorithmIndices;
    private boolean showUtilities;
    private boolean sortByUtility;
    private String dataPath;
    private String resultsPath;
    private boolean parallelized = true;
    private boolean saveCPDAGs;
    private boolean savePags;
    private ArrayList<String> dirs;
    private ComparisonGraph comparisonGraph = ComparisonGraph.true_DAG;

    public void compareFromFiles(String filePath, Algorithms algorithms, Statistics statistics, Parameters parameters, long timeout, TimeUnit unit) {
        this.compareFromFiles(filePath, filePath, algorithms, statistics, parameters, timeout, unit);
    }

    public void compareFromFiles(String dataPath, String resultsPath, Algorithms algorithms, Statistics statistics, Parameters parameters, long timeout, TimeUnit unit) {
        for (Algorithm algorithm : algorithms.getAlgorithms()) {
            if (!(algorithm instanceof ExternalAlgorithm)) continue;
            throw new IllegalArgumentException("Not expecting any implementations of ExternalAlgorithm here.");
        }
        this.dataPath = dataPath;
        this.resultsPath = resultsPath;
        Simulations simulations = new Simulations();
        File file = new File(this.dataPath, "save");
        File[] dirs = file.listFiles();
        if (dirs == null) {
            throw new NullPointerException("No files in " + file.getAbsolutePath());
        }
        this.dirs = new ArrayList();
        int count = 0;
        for (File dir : dirs) {
            if (dir.getName().contains("DS_Store")) continue;
            ++count;
        }
        for (int i = 1; i <= count; ++i) {
            File _dir = new File(dataPath, "save/" + i);
            simulations.add(new LoadDataAndGraphs(_dir.getAbsolutePath()));
            this.dirs.add(_dir.getAbsolutePath());
        }
        this.compareFromSimulations(this.resultsPath, simulations, algorithms, statistics, parameters, timeout, unit);
    }

    public void generateReportFromExternalAlgorithms(String dataPath, String resultsPath, Algorithms algorithms, Statistics statistics, Parameters parameters, long timeout, TimeUnit unit) {
        this.generateReportFromExternalAlgorithms(dataPath, resultsPath, "Comparison.txt", algorithms, statistics, parameters, timeout, unit);
    }

    public void generateReportFromExternalAlgorithms(String dataPath, String resultsPath, String outputFileName, Algorithms algorithms, Statistics statistics, Parameters parameters, long timeout, TimeUnit unit) {
        this.saveGraphs = false;
        this.dataPath = dataPath;
        this.resultsPath = resultsPath;
        for (Algorithm algorithm : algorithms.getAlgorithms()) {
            if (algorithm instanceof ExternalAlgorithm) continue;
            throw new IllegalArgumentException("Expecting all algorithms to implement ExternalAlgorithm.");
        }
        Simulations simulations = new Simulations();
        File file = new File(this.dataPath, "save");
        File[] dirs = file.listFiles();
        if (dirs == null) {
            throw new NullPointerException("No files in " + file.getAbsolutePath());
        }
        this.dirs = new ArrayList();
        int count = 0;
        for (File dir : dirs) {
            if (dir.getName().contains("DS_Store")) continue;
            ++count;
        }
        for (int i = 1; i <= count; ++i) {
            File _dir = new File(dataPath, "save/" + i);
            simulations.add(new LoadDataAndGraphs(_dir.getAbsolutePath()));
            this.dirs.add(_dir.getAbsolutePath());
        }
        this.compareFromSimulations(this.resultsPath, simulations, outputFileName, algorithms, statistics, parameters, timeout, unit);
    }

    public void compareFromSimulations(String resultsPath, Simulations simulations, Algorithms algorithms, Statistics statistics, Parameters parameters, long timeout, TimeUnit unit) {
        this.compareFromSimulations(resultsPath, simulations, "Comparison.txt", algorithms, statistics, parameters, timeout, unit);
    }

    public void compareFromSimulations(String resultsPath, Simulations simulations, String outputFileName, Algorithms algorithms, Statistics statistics, Parameters parameters, long timeout, TimeUnit unit) {
        this.resultsPath = resultsPath;
        try {
            File dir = new File(resultsPath);
            dir.mkdirs();
            File file = new File(dir, outputFileName);
            this.out = new PrintStream(new FileOutputStream(file));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.out.println(new Date());
        ArrayList<SimulationWrapper> simulationWrappers = new ArrayList<SimulationWrapper>();
        int numRuns = parameters.getInt("numRuns");
        for (Simulation simulation : simulations.getSimulations()) {
            List<SimulationWrapper> list = this.getSimulationWrappers(simulation, parameters);
            for (SimulationWrapper wrapper : list) {
                wrapper.createData(wrapper.getSimulationSpecificParameters(), false);
                simulationWrappers.add(wrapper);
            }
        }
        ArrayList<AlgorithmWrapper> algorithmWrappers = new ArrayList<AlgorithmWrapper>();
        for (Algorithm algorithm : algorithms.getAlgorithms()) {
            int[] choice;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList varyingParameters = new ArrayList();
            List<String> parameters1 = algorithm.getParameters();
            for (String name : parameters1) {
                if (parameters.getNumValues(name) <= 1) continue;
                arrayList.add(parameters.getNumValues(name));
                varyingParameters.add(name);
            }
            if (varyingParameters.isEmpty()) {
                algorithmWrappers.add(new AlgorithmWrapper(algorithm, parameters));
                continue;
            }
            int[] dims = new int[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                dims[i] = (Integer)arrayList.get(i);
            }
            CombinationGenerator gen = new CombinationGenerator(dims);
            while ((choice = gen.next()) != null) {
                AlgorithmWrapper wrapper = new AlgorithmWrapper(algorithm, parameters);
                for (int h = 0; h < dims.length; ++h) {
                    String parameter = (String)varyingParameters.get(h);
                    Object[] values = parameters.getValues(parameter);
                    Object value = values[choice[h]];
                    wrapper.setValue(parameter, value);
                }
                algorithmWrappers.add(wrapper);
            }
        }
        ArrayList<AlgorithmSimulationWrapper> arrayList = new ArrayList<AlgorithmSimulationWrapper>();
        for (SimulationWrapper simulationWrapper : simulationWrappers) {
            for (AlgorithmWrapper algorithmWrapper : algorithmWrappers) {
                DataType algDataType = algorithmWrapper.getDataType();
                DataType simDataType = simulationWrapper.getDataType();
                if (algDataType != DataType.Mixed && algDataType != simDataType) {
                    System.out.println("Type mismatch: " + algorithmWrapper.getDescription() + " / " + simulationWrapper.getDescription());
                }
                if (algorithmWrapper.getAlgorithm() instanceof ExternalAlgorithm) {
                    ExternalAlgorithm external = (ExternalAlgorithm)algorithmWrapper.getAlgorithm();
                    external.setSimIndex(simulationWrappers.indexOf(external.getSimulation()));
                }
                arrayList.add(new AlgorithmSimulationWrapper(algorithmWrapper, simulationWrapper));
            }
        }
        double[][][][] dArray = this.calcStats(arrayList, algorithmWrappers, simulationWrappers, statistics, numRuns, timeout, unit);
        if (dArray != null) {
            this.out.println();
            this.out.println("Statistics:");
            this.out.println();
            for (Statistic stat : statistics.getStatistics()) {
                this.out.println(stat.getAbbreviation() + " = " + stat.getDescription());
            }
        }
        this.out.println();
        if (dArray != null) {
            int u;
            int[] newOrder;
            int n = dArray.length;
            int numStats = dArray[0][0].length - 1;
            double[][][] statTables = this.calcStatTables(dArray, Mode.Average, n, arrayList, numStats, statistics);
            double[] utilities = this.calcUtilities(statistics, arrayList, statTables[0]);
            for (int u2 = 0; u2 < n; ++u2) {
                for (int t = 0; t < arrayList.size(); ++t) {
                    statTables[u2][t][numStats] = utilities[t];
                }
            }
            if (this.isSortByUtility()) {
                newOrder = this.sort(arrayList, utilities);
            } else {
                newOrder = new int[arrayList.size()];
                for (int q = 0; q < arrayList.size(); ++q) {
                    newOrder[q] = q;
                }
            }
            this.out.println("Simulations:");
            this.out.println();
            int i = 0;
            for (SimulationWrapper simulation : simulationWrappers) {
                this.out.print("Simulation " + ++i + ": ");
                this.out.println(simulation.getDescription());
                this.out.println();
                this.printParameters(simulation.getParameters(), simulation.getSimulationSpecificParameters(), this.out);
                this.out.println();
            }
            this.out.println("Algorithms:");
            this.out.println();
            for (int t = 0; t < arrayList.size(); ++t) {
                AlgorithmSimulationWrapper wrapper = (AlgorithmSimulationWrapper)arrayList.get(t);
                if (wrapper.getSimulationWrapper() != simulationWrappers.get(0)) continue;
                this.out.println(t + 1 + ". " + wrapper.getAlgorithmWrapper().getDescription());
            }
            if (this.isSortByUtility()) {
                this.out.println();
                this.out.println("Sorting by utility, high to low.");
            }
            if (this.isShowUtilities()) {
                this.out.println();
                this.out.println("Weighting of statistics:");
                this.out.println();
                this.out.println("U = ");
                for (Statistic stat : statistics.getStatistics()) {
                    String statName = stat.getAbbreviation();
                    double weight = statistics.getWeight(stat);
                    if (weight == 0.0) continue;
                    this.out.println("    " + weight + " * f(" + statName + ")");
                }
                this.out.println();
                this.out.println("...normed to range between 0 and 1.");
                this.out.println();
                this.out.println("Note that f for each statistic is a function that maps the statistic to the ");
                this.out.println("interval [0, 1], with higher being better.");
            }
            this.out.println();
            this.out.println("Graphs are being compared to the " + this.comparisonGraph.toString().replace("_", " ") + ".");
            this.out.println();
            for (u = 0; u < n; ++u) {
                for (int t = 0; t < arrayList.size(); ++t) {
                    statTables[u][t][numStats] = utilities[t];
                }
            }
            this.printStats(statTables, statistics, Mode.Average, newOrder, arrayList, algorithmWrappers, simulationWrappers, utilities, parameters);
            statTables = this.calcStatTables(dArray, Mode.StandardDeviation, n, arrayList, numStats, statistics);
            this.printStats(statTables, statistics, Mode.StandardDeviation, newOrder, arrayList, algorithmWrappers, simulationWrappers, utilities, parameters);
            statTables = this.calcStatTables(dArray, Mode.WorstCase, n, arrayList, numStats, statistics);
            for (u = 0; u < n; ++u) {
                for (int t = 0; t < arrayList.size(); ++t) {
                    statTables[u][t][numStats] = utilities[t];
                }
            }
            this.printStats(statTables, statistics, Mode.WorstCase, newOrder, arrayList, algorithmWrappers, simulationWrappers, utilities, parameters);
        }
        this.out.close();
    }

    public void saveToFiles(String dataPath, Simulation simulation, Parameters parameters) {
        List<SimulationWrapper> simulationWrappers = this.getSimulationWrappers(simulation, parameters);
        File dir0 = new File(dataPath);
        boolean i = false;
        File dir = new File(dir0, "save");
        this.deleteFilesThenDirectory(dir);
        try {
            int index = 0;
            for (SimulationWrapper simulationWrapper : simulationWrappers) {
                for (String param : simulationWrapper.getParameters()) {
                    parameters.set(param, simulationWrapper.getValue(param));
                }
                simulationWrapper.createData(simulationWrapper.getSimulationSpecificParameters(), false);
                File subdir = new File(dir, "" + ++index);
                subdir.mkdirs();
                File dir1 = new File(subdir, "graph");
                File dir2 = new File(subdir, "data");
                dir1.mkdirs();
                dir2.mkdirs();
                File dir3 = null;
                if (this.isSaveCPDAGs()) {
                    dir3 = new File(subdir, "patterns");
                    dir3.mkdirs();
                }
                File dir4 = null;
                if (this.isSavePags()) {
                    dir4 = new File(subdir, "pags");
                    dir4.mkdirs();
                }
                for (int j = 0; j < simulationWrapper.getNumDataModels(); ++j) {
                    File file2 = new File(dir1, "graph." + (j + 1) + ".txt");
                    Graph graph = simulationWrapper.getTrueGraph(j);
                    GraphSaveLoadUtils.saveGraph(graph, file2, false);
                    File file = new File(dir2, "data." + (j + 1) + ".txt");
                    FileWriter out = new FileWriter(file);
                    DataModel dataModel = simulationWrapper.getDataModel(j);
                    DataWriter.writeRectangularData((DataSet)dataModel, out, '\t');
                    ((Writer)out).close();
                    if (this.isSaveCPDAGs()) {
                        File file3 = new File(dir3, "pattern." + (j + 1) + ".txt");
                        GraphSaveLoadUtils.saveGraph(GraphTransforms.cpdagForDag(graph), file3, false);
                    }
                    if (!this.isSavePags()) continue;
                    File file4 = new File(dir4, "pag." + (j + 1) + ".txt");
                    GraphSaveLoadUtils.saveGraph(GraphTransforms.dagToPag(graph), file4, false);
                }
                PrintStream out = new PrintStream(Files.newOutputStream(new File(subdir, "parameters.txt").toPath(), new OpenOption[0]));
                out.println(simulationWrapper.getDescription());
                out.println(simulationWrapper.getSimulationSpecificParameters());
                out.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void configuration(String path) {
        try {
            Algorithm algorithm;
            Constructor<?>[] constructors;
            new File(path).mkdirs();
            PrintStream out = new PrintStream(Files.newOutputStream(new File(path, "Configuration.txt").toPath(), new OpenOption[0]));
            Parameters allParams = new Parameters();
            ArrayList<Class> algorithms = new ArrayList<Class>(this.getClasses(Algorithm.class));
            ArrayList<Class> statistics = new ArrayList<Class>(this.getClasses(Statistic.class));
            ArrayList<Class> independenceWrappers = new ArrayList<Class>(this.getClasses(IndependenceWrapper.class));
            ArrayList<Class> scoreWrappers = new ArrayList<Class>(this.getClasses(ScoreWrapper.class));
            ArrayList<Class> simulations = new ArrayList<Class>(this.getClasses(Simulation.class));
            out.println("Available Algorithms:");
            out.println();
            out.println("Algorithms that take an independence test (using an example independence test):");
            out.println();
            for (Class clazz : new ArrayList<Class>(algorithms)) {
                if (Experimental.class.isAssignableFrom(clazz)) continue;
                for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
                    if (constructor.getParameterTypes().length != 1 || constructor.getParameterTypes()[0] != IndependenceWrapper.class) continue;
                    algorithm = (Algorithm)constructor.newInstance(FisherZ.class.newInstance());
                    out.println(clazz.getSimpleName() + ": " + algorithm.getDescription());
                    if (HasParameters.class.isAssignableFrom(clazz)) {
                        this.printParameters(algorithm.getParameters(), allParams, out);
                    }
                    if (!TakesExternalGraph.class.isAssignableFrom(clazz)) continue;
                    out.println("\t" + clazz.getSimpleName() + " can take an initial graph from some other algorithm as input");
                }
            }
            out.println();
            out.println("Algorithms that take a score (using an example score):");
            out.println();
            for (Class clazz : new ArrayList<Class>(algorithms)) {
                if (Experimental.class.isAssignableFrom(clazz)) continue;
                for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
                    if (constructor.getParameterTypes().length != 1 || constructor.getParameterTypes()[0] != ScoreWrapper.class) continue;
                    algorithm = (Algorithm)constructor.newInstance(BdeuScore.class.newInstance());
                    out.println(clazz.getSimpleName() + ": " + algorithm.getDescription());
                    if (!HasParameters.class.isAssignableFrom(clazz)) continue;
                    this.printParameters(algorithm.getParameters(), allParams, out);
                }
            }
            out.println();
            out.println("Algorithms with blank constructor:");
            out.println();
            for (Class clazz : new ArrayList<Class>(algorithms)) {
                if (Experimental.class.isAssignableFrom(clazz)) continue;
                for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
                    if (constructor.getParameterTypes().length != 0) continue;
                    algorithm = (Algorithm)constructor.newInstance(new Object[0]);
                    out.println(clazz.getSimpleName() + ": " + algorithm.getDescription());
                    if (!HasParameters.class.isAssignableFrom(clazz)) continue;
                    this.printParameters(algorithm.getParameters(), allParams, out);
                }
            }
            out.println();
            out.println("Available Statistics:");
            out.println();
            for (Class<Object> clazz : statistics) {
                if (Experimental.class.isAssignableFrom(clazz)) continue;
                for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
                    if (constructor.getParameterTypes().length != 0) continue;
                    Statistic statistic = (Statistic)constructor.newInstance(new Object[0]);
                    out.println(clazz.getSimpleName() + ": " + statistic.getDescription());
                }
            }
            out.println();
            out.println("Available Independence Tests:");
            out.println();
            for (Class<Object> clazz : independenceWrappers) {
                if (Experimental.class.isAssignableFrom(clazz)) continue;
                for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
                    if (constructor.getParameterTypes().length != 0) continue;
                    IndependenceWrapper independence = (IndependenceWrapper)constructor.newInstance(new Object[0]);
                    out.println(clazz.getSimpleName() + ": " + independence.getDescription());
                    if (!HasParameters.class.isAssignableFrom(clazz)) continue;
                    this.printParameters(independence.getParameters(), allParams, out);
                }
            }
            out.println();
            out.println("Available Scores:");
            out.println();
            for (Class<Object> clazz : scoreWrappers) {
                if (Experimental.class.isAssignableFrom(clazz)) continue;
                for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
                    if (constructor.getParameterTypes().length != 0) continue;
                    ScoreWrapper score = (ScoreWrapper)constructor.newInstance(new Object[0]);
                    out.println(clazz.getSimpleName() + ": " + score.getDescription());
                    if (!HasParameters.class.isAssignableFrom(clazz)) continue;
                    this.printParameters(score.getParameters(), allParams, out);
                }
            }
            out.println();
            out.println("Available Simulations:");
            out.println();
            for (Class<Object> clazz : simulations) {
                if (Experimental.class.isAssignableFrom(clazz)) continue;
                for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
                    if (constructor.getParameterTypes().length != 0) continue;
                    Simulation simulation = (Simulation)constructor.newInstance(new Object[0]);
                    out.println(clazz.getSimpleName() + ": " + simulation.getDescription());
                    if (!HasParameters.class.isAssignableFrom(clazz)) continue;
                    this.printParameters(simulation.getParameters(), allParams, out);
                }
            }
            out.println();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<Class> getClasses(Class type) {
        Reflections reflections = new Reflections(new Object[0]);
        Set allClasses = reflections.getSubTypesOf(type);
        return new ArrayList<Class>(allClasses);
    }

    private List<SimulationWrapper> getSimulationWrappers(Simulation simulation, Parameters parameters) {
        ArrayList<SimulationWrapper> simulationWrappers = new ArrayList<SimulationWrapper>();
        ArrayList<Integer> _dims = new ArrayList<Integer>();
        ArrayList<String> varyingParams = new ArrayList<String>();
        List<String> parameters1 = simulation.getParameters();
        for (String param : parameters1) {
            int numValues = parameters.getNumValues(param);
            if (numValues <= 1) continue;
            _dims.add(numValues);
            varyingParams.add(param);
        }
        if (varyingParams.isEmpty()) {
            simulationWrappers.add(new SimulationWrapper(simulation, parameters));
        } else {
            int[] choice;
            int[] dims = new int[_dims.size()];
            for (int i = 0; i < _dims.size(); ++i) {
                dims[i] = (Integer)_dims.get(i);
            }
            CombinationGenerator gen = new CombinationGenerator(dims);
            while ((choice = gen.next()) != null) {
                SimulationWrapper wrapper = new SimulationWrapper(simulation, parameters);
                for (int h = 0; h < dims.length; ++h) {
                    String param = (String)varyingParams.get(h);
                    Object[] values = parameters.getValues(param);
                    Object value = values[choice[h]];
                    wrapper.setValue(param, value);
                }
                simulationWrappers.add(wrapper);
            }
        }
        return simulationWrappers;
    }

    private double[][][][] calcStats(List<AlgorithmSimulationWrapper> algorithmSimulationWrappers, List<AlgorithmWrapper> algorithmWrappers, List<SimulationWrapper> simulationWrappers, Statistics statistics, int numRuns, long timeout, TimeUnit unit) {
        int numGraphTypes = 4;
        this.graphTypeUsed = new boolean[4];
        double[][][][] allStats = new double[4][algorithmSimulationWrappers.size()][statistics.size() + 1][numRuns];
        ArrayList<AlgorithmTask> tasks = new ArrayList<AlgorithmTask>();
        int index = 0;
        for (int algSimIndex = 0; algSimIndex < algorithmSimulationWrappers.size(); ++algSimIndex) {
            for (int runIndex = 0; runIndex < numRuns; ++runIndex) {
                AlgorithmSimulationWrapper algorithmSimulationWrapper = algorithmSimulationWrappers.get(algSimIndex);
                Run run = new Run(algSimIndex, runIndex, index++, algorithmSimulationWrapper);
                AlgorithmTask task2 = new AlgorithmTask(algorithmSimulationWrappers, algorithmWrappers, simulationWrappers, statistics, 4, allStats, run);
                tasks.add(task2);
            }
        }
        ExecutorService pool = Executors.newSingleThreadExecutor();
        tasks.forEach(task -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
        this.shutdownAndAwaitTermination(pool);
        return allStats;
    }

    private String dateTimeNow() {
        return DF.format(new Date(MillisecondTimes.timeMillis()));
    }

    private void shutdownAndAwaitTermination(ExecutorService pool) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(1L, TimeUnit.SECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(1L, TimeUnit.SECONDS)) {
                    System.err.println("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public boolean isShowSimulationIndices() {
        return this.showSimulationIndices;
    }

    public void setShowSimulationIndices(boolean showSimulationIndices) {
        this.showSimulationIndices = showSimulationIndices;
    }

    public boolean isShowAlgorithmIndices() {
        return this.showAlgorithmIndices;
    }

    public void setShowAlgorithmIndices(boolean showAlgorithmIndices) {
        this.showAlgorithmIndices = showAlgorithmIndices;
    }

    public boolean isShowUtilities() {
        return this.showUtilities;
    }

    public void setShowUtilities(boolean showUtilities) {
        this.showUtilities = showUtilities;
    }

    public boolean isSortByUtility() {
        return this.sortByUtility;
    }

    public void setSortByUtility(boolean sortByUtility) {
        this.sortByUtility = sortByUtility;
    }

    public boolean isParallelized() {
        return this.parallelized;
    }

    public void setParallelized(boolean parallelized) {
        this.parallelized = parallelized;
    }

    public boolean isSaveCPDAGs() {
        return this.saveCPDAGs;
    }

    public void setSaveCPDAGs(boolean saveCPDAGs) {
        this.saveCPDAGs = saveCPDAGs;
    }

    public boolean isSavePags() {
        return this.savePags;
    }

    public void setSavePags(boolean savePags) {
        this.savePags = savePags;
    }

    public boolean isTabDelimitedTables() {
        return this.tabDelimitedTables;
    }

    public void setTabDelimitedTables(boolean tabDelimitedTables) {
        this.tabDelimitedTables = tabDelimitedTables;
    }

    public boolean isSaveGraphs() {
        return this.saveGraphs;
    }

    public void setSaveGraphs(boolean saveGraphs) {
        this.saveGraphs = saveGraphs;
    }

    public boolean isCopyData() {
        return this.copyData;
    }

    public void setCopyData(boolean copyData) {
        this.copyData = copyData;
    }

    public ComparisonGraph getComparisonGraph() {
        return this.comparisonGraph;
    }

    public void setComparisonGraph(ComparisonGraph comparisonGraph) {
        if (comparisonGraph == null) {
            throw new NullPointerException("Null compare graph.");
        }
        this.comparisonGraph = comparisonGraph;
    }

    private void printParameters(List<String> names, Parameters parameters, PrintStream out) {
        ParamDescriptions descriptions = ParamDescriptions.getInstance();
        for (String name : names) {
            ParamDescription description = descriptions.get(name);
            Object value = parameters.get(name);
            if (value instanceof Double) {
                out.println(description.getShortDescription() + " = " + value);
                continue;
            }
            if (value instanceof Integer) {
                out.println(description.getShortDescription() + " = " + value);
                continue;
            }
            if (value instanceof Boolean) {
                boolean b = (Boolean)value;
                out.println(description.getShortDescription() + " = " + (b ? "Yes" : "No"));
                continue;
            }
            if (!(value instanceof String)) continue;
            out.println(description.getShortDescription() + " = " + value);
        }
    }

    private void deleteFilesThenDirectory(File dir) {
        if (dir == null) {
            return;
        }
        String[] entries = dir.list();
        if (entries == null) {
            return;
        }
        for (String s : entries) {
            File currentFile = new File(dir.getPath(), s);
            if (currentFile.isDirectory()) {
                this.deleteFilesThenDirectory(currentFile);
                continue;
            }
            currentFile.delete();
        }
        dir.delete();
    }

    private void doRun(List<AlgorithmSimulationWrapper> algorithmSimulationWrappers, List<AlgorithmWrapper> algorithmWrappers, List<SimulationWrapper> simulationWrappers, Statistics statistics, int numGraphTypes, double[][][][] allStats, Run run) {
        Graph comparisonGraph;
        Graph out;
        System.out.println();
        System.out.println("Run " + (run.getRunIndex() + 1));
        System.out.println();
        AlgorithmSimulationWrapper algorithmSimulationWrapper = algorithmSimulationWrappers.get(run.getAlgSimIndex());
        AlgorithmWrapper algorithmWrapper = algorithmSimulationWrapper.getAlgorithmWrapper();
        SimulationWrapper simulationWrapper = algorithmSimulationWrapper.getSimulationWrapper();
        DataModel data = simulationWrapper.getDataModel(run.getRunIndex());
        Graph trueGraph = simulationWrapper.getTrueGraph(run.getRunIndex());
        System.out.println(run.getAlgSimIndex() + 1 + ". " + algorithmWrapper.getDescription() + " simulationWrapper: " + simulationWrapper.getDescription());
        long start = MillisecondTimes.timeMillis();
        try {
            Algorithm algorithm = algorithmWrapper.getAlgorithm();
            Simulation simulation = simulationWrapper.getSimulation();
            if (algorithm instanceof HasKnowledge && simulation instanceof HasKnowledge) {
                ((HasKnowledge)((Object)algorithm)).setKnowledge(((HasKnowledge)((Object)simulation)).getKnowledge());
            }
            if (algorithmWrapper.getAlgorithm() instanceof ExternalAlgorithm) {
                ExternalAlgorithm external = (ExternalAlgorithm)algorithmWrapper.getAlgorithm();
                external.setSimulation(simulationWrapper.getSimulation());
                external.setPath(this.resultsPath);
                external.setSimIndex(simulationWrappers.indexOf(simulationWrapper));
            }
            if (algorithm instanceof MultiDataSetAlgorithm) {
                ArrayList<Integer> indices = new ArrayList<Integer>();
                int numDataModels = simulationWrapper.getSimulation().getNumDataModels();
                for (int i = 0; i < numDataModels; ++i) {
                    indices.add(i);
                }
                RandomUtil.shuffle(indices);
                ArrayList<DataModel> dataModels = new ArrayList<DataModel>();
                int randomSelectionSize = algorithmWrapper.getAlgorithmSpecificParameters().getInt("randomSelectionSize");
                for (int i = 0; i < FastMath.min(numDataModels, randomSelectionSize); ++i) {
                    dataModels.add(simulationWrapper.getSimulation().getDataModel((Integer)indices.get(i)));
                }
                Parameters _params = algorithmWrapper.getAlgorithmSpecificParameters();
                out = ((MultiDataSetAlgorithm)algorithm).search(dataModels, _params);
            } else {
                DataModel dataModel = this.copyData ? data.copy() : data;
                Parameters _params = algorithmWrapper.getAlgorithmSpecificParameters();
                out = algorithm.search(dataModel, _params);
            }
        }
        catch (Exception e) {
            System.out.println("Could not run " + algorithmWrapper.getDescription());
            e.printStackTrace();
            return;
        }
        int simIndex = simulationWrappers.indexOf(simulationWrapper) + 1;
        int algIndex = algorithmWrappers.indexOf(algorithmWrapper) + 1;
        long stop = MillisecondTimes.timeMillis();
        long elapsed = stop - start;
        this.saveGraph(this.resultsPath, out, run.getRunIndex(), simIndex, algIndex, algorithmWrapper, elapsed);
        if (trueGraph != null) {
            out = GraphUtils.replaceNodes(out, trueGraph.getNodes());
        }
        if (algorithmWrapper.getAlgorithm() instanceof ExternalAlgorithm) {
            ExternalAlgorithm extAlg = (ExternalAlgorithm)algorithmWrapper.getAlgorithm();
            extAlg.setSimIndex(simulationWrappers.indexOf(simulationWrapper));
            extAlg.setSimulation(simulationWrapper.getSimulation());
            extAlg.setPath(this.resultsPath);
            elapsed = extAlg.getElapsedTime(data, simulationWrapper.getSimulationSpecificParameters());
        }
        Graph[] est = new Graph[numGraphTypes];
        if (this.comparisonGraph == ComparisonGraph.true_DAG) {
            comparisonGraph = new EdgeListGraph(trueGraph);
        } else if (this.comparisonGraph == ComparisonGraph.CPDAG_of_the_true_DAG) {
            EdgeListGraph dag = new EdgeListGraph(trueGraph);
            comparisonGraph = GraphTransforms.cpdagForDag(dag);
        } else if (this.comparisonGraph == ComparisonGraph.PAG_of_the_true_DAG) {
            EdgeListGraph trueGraph1 = new EdgeListGraph(trueGraph);
            comparisonGraph = GraphTransforms.dagToPag(trueGraph1);
        } else {
            throw new IllegalArgumentException("Unrecognized graph type.");
        }
        est[0] = out;
        this.graphTypeUsed[0] = true;
        if (data.isMixed()) {
            est[1] = this.getSubgraph(out, true, true, data);
            est[2] = this.getSubgraph(out, true, false, data);
            est[3] = this.getSubgraph(out, false, false, data);
            this.graphTypeUsed[1] = true;
            this.graphTypeUsed[2] = true;
            this.graphTypeUsed[3] = true;
        }
        Graph[] truth = new Graph[numGraphTypes];
        truth[0] = comparisonGraph;
        if (data.isMixed() && comparisonGraph != null) {
            truth[1] = this.getSubgraph(comparisonGraph, true, true, data);
            truth[2] = this.getSubgraph(comparisonGraph, true, false, data);
            truth[3] = this.getSubgraph(comparisonGraph, false, false, data);
        }
        if (comparisonGraph != null) {
            for (int u = 0; u < numGraphTypes; ++u) {
                if (!this.graphTypeUsed[u]) continue;
                int statIndex = -1;
                for (Statistic _stat : statistics.getStatistics()) {
                    ++statIndex;
                    if (_stat instanceof ParameterColumn) continue;
                    double stat = _stat instanceof ElapsedCpuTime ? (double)elapsed / 1000.0 : _stat.getValue(truth[u], est[u], null);
                    allStats[u][run.getAlgSimIndex()][statIndex][run.getRunIndex()] = stat;
                }
            }
        }
    }

    private void saveGraph(String resultsPath, Graph graph, int i, int simIndex, int algIndex, AlgorithmWrapper algorithmWrapper, long elapsed) {
        if (!this.saveGraphs) {
            return;
        }
        try {
            String description = algorithmWrapper.getDescription().replace(" ", "_");
            File dir = new File(resultsPath, "results/" + description + "/" + simIndex);
            dir.mkdirs();
            File dirElapsed = new File(resultsPath, "elapsed/" + description + "/" + simIndex);
            dirElapsed.mkdirs();
            if (resultsPath == null) {
                throw new IllegalArgumentException("Results path not provided.");
            }
            File file = new File(dir, "graph." + (i + 1) + ".txt");
            File fileElapsed = new File(dirElapsed, "graph." + (i + 1) + ".txt");
            PrintStream out = new PrintStream(file);
            System.out.println("Saving graph to " + file.getAbsolutePath());
            out.println(graph);
            out.close();
            PrintStream outElapsed = new PrintStream(fileElapsed);
            outElapsed.println(elapsed);
            outElapsed.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private String getHeader(int u) {
        String header;
        switch (u) {
            case 0: {
                header = "All edges";
                break;
            }
            case 1: {
                header = "Discrete-discrete";
                break;
            }
            case 2: {
                header = "Discrete-continuous";
                break;
            }
            case 3: {
                header = "Continuous-continuous";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return header;
    }

    private double[][][] calcStatTables(double[][][][] allStats, Mode mode, int numTables, List<AlgorithmSimulationWrapper> wrappers, int numStats, Statistics statistics) {
        double[][][] statTables = new double[numTables][wrappers.size()][numStats + 1];
        for (int u = 0; u < numTables; ++u) {
            for (int i = 0; i < wrappers.size(); ++i) {
                for (int j = 0; j < numStats; ++j) {
                    if (statistics.getStatistics().get(j) instanceof ParameterColumn) {
                        String statName = statistics.getStatistics().get(j).getAbbreviation();
                        SimulationWrapper simulationWrapper = wrappers.get(i).getSimulationWrapper();
                        AlgorithmWrapper algorithmWrapper = wrappers.get(i).getAlgorithmWrapper();
                        double stat = Double.NaN;
                        List<String> parameterNames = simulationWrapper.getParameters();
                        Parameters parameters = simulationWrapper.getSimulationSpecificParameters();
                        for (String name : parameterNames) {
                            if (!name.equals(statName)) continue;
                            if (parameters.get(name) instanceof Boolean) {
                                boolean b = parameters.getBoolean(name);
                                stat = b ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
                                break;
                            }
                            stat = parameters.getDouble(name);
                            break;
                        }
                        if (Double.isNaN(stat)) {
                            List<String> _parameterNames = algorithmWrapper.getParameters();
                            Parameters _parameters = algorithmWrapper.parameters;
                            for (String name : _parameterNames) {
                                if (!name.equals(statName)) continue;
                                try {
                                    stat = _parameters.getDouble(name);
                                }
                                catch (Exception e) {
                                    boolean b = _parameters.getBoolean(name);
                                    stat = b ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
                                }
                                break;
                            }
                        }
                        statTables[u][i][j] = stat;
                        continue;
                    }
                    if (mode == Mode.Average) {
                        statTables[u][i][j] = StatUtils.mean(allStats[u][i][j]);
                        continue;
                    }
                    if (mode == Mode.WorstCase) {
                        statTables[u][i][j] = StatUtils.min(allStats[u][i][j]);
                        continue;
                    }
                    if (mode == Mode.StandardDeviation) {
                        statTables[u][i][j] = StatUtils.sd(allStats[u][i][j]);
                        continue;
                    }
                    throw new IllegalStateException();
                }
            }
        }
        return statTables;
    }

    private void printStats(double[][][] statTables, Statistics statistics, Mode mode, int[] newOrder, List<AlgorithmSimulationWrapper> algorithmSimulationWrappers, List<AlgorithmWrapper> algorithmWrappers, List<SimulationWrapper> simulationWrappers, double[] utilities, Parameters parameters) {
        if (mode == Mode.Average) {
            this.out.println("AVERAGE STATISTICS");
        } else if (mode == Mode.StandardDeviation) {
            this.out.println("STANDARD DEVIATIONS");
        } else if (mode == Mode.WorstCase) {
            this.out.println("WORST CASE");
        } else {
            throw new IllegalStateException();
        }
        int numTables = statTables.length;
        int numStats = statistics.size();
        DecimalFormat nf = new DecimalFormat("0.00");
        DecimalFormat smallNf = new DecimalFormat("0.00E0");
        this.out.println();
        for (int u = 0; u < numTables; ++u) {
            int t;
            if (!this.graphTypeUsed[u]) continue;
            int rows = algorithmSimulationWrappers.size() + 1;
            int cols = (this.isShowSimulationIndices() ? 1 : 0) + (this.isShowAlgorithmIndices() ? 1 : 0) + numStats + (this.isShowUtilities() ? 1 : 0);
            TextTable table = new TextTable(rows, cols);
            table.setDelimiter(this.isTabDelimitedTables() ? TextTable.Delimiter.TAB : TextTable.Delimiter.JUSTIFIED);
            int initialColumn = 0;
            if (this.isShowSimulationIndices()) {
                table.setToken(0, initialColumn, "Sim");
                for (t = 0; t < algorithmSimulationWrappers.size(); ++t) {
                    SimulationWrapper simulation = algorithmSimulationWrappers.get(newOrder[t]).getSimulationWrapper();
                    table.setToken(t + 1, initialColumn, "" + (simulationWrappers.indexOf(simulation) + 1));
                }
                ++initialColumn;
            }
            if (this.isShowAlgorithmIndices()) {
                table.setToken(0, initialColumn, "Alg");
                for (t = 0; t < algorithmSimulationWrappers.size(); ++t) {
                    AlgorithmWrapper algorithm = algorithmSimulationWrappers.get(newOrder[t]).getAlgorithmWrapper();
                    table.setToken(t + 1, initialColumn, "" + (algorithmWrappers.indexOf(algorithm) + 1));
                }
                ++initialColumn;
            }
            for (int statIndex = 0; statIndex < numStats; ++statIndex) {
                String statLabel = statistics.getStatistics().get(statIndex).getAbbreviation();
                table.setToken(0, initialColumn + statIndex, statLabel);
            }
            if (this.isShowUtilities()) {
                table.setToken(0, initialColumn + numStats, "U");
            }
            for (t = 0; t < algorithmSimulationWrappers.size(); ++t) {
                for (int statIndex = 0; statIndex < numStats; ++statIndex) {
                    String abbreviation;
                    Object[] o;
                    Statistic statistic = statistics.getStatistics().get(statIndex);
                    AlgorithmWrapper algorithmWrapper = algorithmSimulationWrappers.get(newOrder[t]).getAlgorithmWrapper();
                    SimulationWrapper simulationWrapper = algorithmSimulationWrappers.get(newOrder[t]).getSimulationWrapper();
                    Algorithm algorithm = algorithmWrapper.getAlgorithm();
                    Simulation simulation = simulationWrapper.getSimulation();
                    if (algorithm instanceof HasParameterValues) {
                        parameters.putAll(((HasParameterValues)((Object)algorithm)).getParameterValues());
                    }
                    if (simulation instanceof HasParameterValues) {
                        parameters.putAll(((HasParameterValues)((Object)simulation)).getParameterValues());
                    }
                    if ((o = parameters.getValues(abbreviation = statistic.getAbbreviation())).length == 1 && o[0] instanceof String) {
                        table.setToken(t + 1, initialColumn + statIndex, (String)o[0]);
                        continue;
                    }
                    double stat = statTables[u][newOrder[t]][statIndex];
                    if (stat == 0.0) {
                        table.setToken(t + 1, initialColumn + statIndex, "-");
                        continue;
                    }
                    if (stat == Double.POSITIVE_INFINITY) {
                        table.setToken(t + 1, initialColumn + statIndex, "Yes");
                        continue;
                    }
                    if (stat == Double.NEGATIVE_INFINITY) {
                        table.setToken(t + 1, initialColumn + statIndex, "No");
                        continue;
                    }
                    if (Double.isNaN(stat)) {
                        table.setToken(t + 1, initialColumn + statIndex, "*");
                        continue;
                    }
                    table.setToken(t + 1, initialColumn + statIndex, FastMath.abs(stat) < FastMath.pow(10.0, -((NumberFormat)smallNf).getMaximumFractionDigits()) && stat != 0.0 ? smallNf.format(stat) : nf.format(stat));
                }
                if (!this.isShowUtilities()) continue;
                table.setToken(t + 1, initialColumn + numStats, nf.format(utilities[newOrder[t]]));
            }
            this.out.println(this.getHeader(u));
            this.out.println();
            this.out.println(table);
        }
    }

    private double[] calcUtilities(Statistics statistics, List<AlgorithmSimulationWrapper> wrappers, double[][] stats) {
        double[] utilities = new double[wrappers.size()];
        for (int t = 0; t < wrappers.size(); ++t) {
            int j = -1;
            Iterator<Statistic> it2 = statistics.getStatistics().iterator();
            double sum = 0.0;
            double max = 0.0;
            while (it2.hasNext()) {
                Statistic stat = it2.next();
                ++j;
                double weight = statistics.getWeight(stat);
                if (weight == 0.0) continue;
                sum += weight * stat.getNormValue(stats[t][j]);
                max += weight;
            }
            utilities[t] = sum / max;
        }
        return utilities;
    }

    private int[] sort(List<AlgorithmSimulationWrapper> algorithmSimulationWrappers, double[] utilities) {
        ArrayList<Integer> order = new ArrayList<Integer>();
        for (int t = 0; t < algorithmSimulationWrappers.size(); ++t) {
            order.add(t);
        }
        final double[] _utilities = Arrays.copyOf(utilities, utilities.length);
        double low = StatUtils.min(utilities);
        for (int t = 0; t < _utilities.length; ++t) {
            low -= 1.0;
            if (!Double.isNaN(_utilities[t])) continue;
            _utilities[t] = low;
        }
        Collections.sort(order, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return -Double.compare(_utilities[o1], _utilities[o2]);
            }
        });
        int[] newOrder = new int[algorithmSimulationWrappers.size()];
        for (int t = 0; t < algorithmSimulationWrappers.size(); ++t) {
            newOrder[t] = (Integer)order.get(t);
        }
        return newOrder;
    }

    private Graph getSubgraph(Graph graph, boolean discrete1, boolean discrete2, DataModel DataModel2) {
        if (discrete1 && discrete2) {
            EdgeListGraph newGraph = new EdgeListGraph(graph.getNodes());
            for (Edge edge : graph.getEdges()) {
                Node node1 = DataModel2.getVariable(edge.getNode1().getName());
                Node node2 = DataModel2.getVariable(edge.getNode2().getName());
                if (!(node1 instanceof DiscreteVariable) || !(node2 instanceof DiscreteVariable)) continue;
                newGraph.addEdge(edge);
            }
            return newGraph;
        }
        if (!discrete1 && !discrete2) {
            EdgeListGraph newGraph = new EdgeListGraph(graph.getNodes());
            for (Edge edge : graph.getEdges()) {
                Node node1 = DataModel2.getVariable(edge.getNode1().getName());
                Node node2 = DataModel2.getVariable(edge.getNode2().getName());
                if (!(node1 instanceof ContinuousVariable) || !(node2 instanceof ContinuousVariable)) continue;
                newGraph.addEdge(edge);
            }
            return newGraph;
        }
        EdgeListGraph newGraph = new EdgeListGraph(graph.getNodes());
        for (Edge edge : graph.getEdges()) {
            Node node1 = DataModel2.getVariable(edge.getNode1().getName());
            Node node2 = DataModel2.getVariable(edge.getNode2().getName());
            if (node1 instanceof DiscreteVariable && node2 instanceof ContinuousVariable) {
                newGraph.addEdge(edge);
            }
            if (!(node1 instanceof ContinuousVariable) || !(node2 instanceof DiscreteVariable)) continue;
            newGraph.addEdge(edge);
        }
        return newGraph;
    }

    private class Run {
        private final int algSimIndex;
        private final int runIndex;
        private final int index;
        private final AlgorithmSimulationWrapper wrapper;

        public Run(int algSimIndex, int runIndex, int index, AlgorithmSimulationWrapper wrapper) {
            this.runIndex = runIndex;
            this.algSimIndex = algSimIndex;
            this.index = index;
            this.wrapper = wrapper;
        }

        public int getAlgSimIndex() {
            return this.algSimIndex;
        }

        public int getRunIndex() {
            return this.runIndex;
        }

        public int getIndex() {
            return this.index;
        }

        public AlgorithmSimulationWrapper getWrapper() {
            return this.wrapper;
        }

        static /* synthetic */ int access$300(Run x0) {
            return x0.index;
        }
    }

    public static enum ComparisonGraph {
        true_DAG,
        CPDAG_of_the_true_DAG,
        PAG_of_the_true_DAG;

    }

    private static class SimulationWrapper
    implements Simulation {
        private static final long serialVersionUID = 23L;
        private final Simulation simulation;
        private List<Graph> graphs;
        private List<DataModel> dataModels;
        private Parameters parameters;

        public SimulationWrapper(Simulation simulation, Parameters parameters) {
            this.simulation = simulation;
            this.parameters = new Parameters(parameters);
        }

        @Override
        public void createData(Parameters parameters, boolean newModel) {
            this.simulation.createData(parameters, false);
            this.graphs = new ArrayList<Graph>();
            this.dataModels = new ArrayList<DataModel>();
            for (int i = 0; i < this.simulation.getNumDataModels(); ++i) {
                this.graphs.add(this.simulation.getTrueGraph(i));
                this.dataModels.add(this.simulation.getDataModel(i));
            }
        }

        @Override
        public int getNumDataModels() {
            return this.dataModels.size();
        }

        @Override
        public Graph getTrueGraph(int index) {
            if (this.graphs.get(index) == null) {
                return null;
            }
            return new EdgeListGraph(this.graphs.get(index));
        }

        @Override
        public DataModel getDataModel(int index) {
            return this.dataModels.get(index);
        }

        @Override
        public DataType getDataType() {
            return this.simulation.getDataType();
        }

        @Override
        public String getDescription() {
            return this.simulation.getDescription();
        }

        @Override
        public List<String> getParameters() {
            return this.simulation.getParameters();
        }

        public void setParameters(Parameters parameters) {
            this.parameters = new Parameters(parameters);
        }

        public void setValue(String name, Object value) {
            if (!(value instanceof Number)) {
                throw new IllegalArgumentException();
            }
            this.parameters.set(name, value);
        }

        public Object getValue(String name) {
            Object[] values = this.parameters.getValues(name);
            if (values == null || values.length == 0) {
                throw new NullPointerException("Expecting parameter to be defined: " + name);
            }
            return values[0];
        }

        public Simulation getSimulation() {
            return this.simulation;
        }

        public Parameters getSimulationSpecificParameters() {
            return this.parameters;
        }
    }

    private static class AlgorithmWrapper
    implements Algorithm {
        private static final long serialVersionUID = 23L;
        private final Algorithm algorithm;
        private final Parameters parameters;
        private final List<String> overriddenParameters = new ArrayList<String>();

        public AlgorithmWrapper(Algorithm algorithm, Parameters parameters) {
            this.algorithm = algorithm;
            this.parameters = new Parameters(parameters);
        }

        @Override
        public Graph search(DataModel DataModel2, Parameters parameters) {
            return this.algorithm.search(DataModel2, this.parameters);
        }

        @Override
        public Graph getComparisonGraph(Graph graph) {
            return this.algorithm.getComparisonGraph(graph);
        }

        @Override
        public String getDescription() {
            StringBuilder description = new StringBuilder();
            description.append(this.algorithm.getDescription());
            if (this.overriddenParameters.size() > 0) {
                for (String name : new ArrayList<String>(this.overriddenParameters)) {
                    description.append(", ").append(name).append(" = ").append(this.parameters.get(name));
                }
            }
            return description.toString();
        }

        @Override
        public DataType getDataType() {
            return this.algorithm.getDataType();
        }

        @Override
        public List<String> getParameters() {
            return this.algorithm.getParameters();
        }

        public void setValue(String name, Object value) {
            if (!(value instanceof Number) && !(value instanceof Boolean)) {
                throw new IllegalArgumentException();
            }
            this.parameters.set(name, value);
            this.overriddenParameters.add(name);
        }

        public Algorithm getAlgorithm() {
            return this.algorithm;
        }

        public Parameters getAlgorithmSpecificParameters() {
            return this.parameters;
        }
    }

    private static class AlgorithmSimulationWrapper
    implements Algorithm {
        private static final long serialVersionUID = 23L;
        private final SimulationWrapper simulationWrapper;
        private final AlgorithmWrapper algorithmWrapper;
        List<String> parameters = new ArrayList<String>();

        public AlgorithmSimulationWrapper(AlgorithmWrapper algorithm, SimulationWrapper simulation) {
            this.algorithmWrapper = algorithm;
            this.simulationWrapper = simulation;
            this.parameters.addAll(this.algorithmWrapper.getParameters());
            this.parameters.addAll(this.simulationWrapper.getParameters());
        }

        @Override
        public Graph search(DataModel DataModel2, Parameters parameters) {
            return this.algorithmWrapper.getAlgorithm().search(DataModel2, parameters);
        }

        @Override
        public Graph getComparisonGraph(Graph graph) {
            return this.algorithmWrapper.getComparisonGraph(graph);
        }

        @Override
        public String getDescription() {
            throw new IllegalArgumentException();
        }

        @Override
        public DataType getDataType() {
            return this.algorithmWrapper.getDataType();
        }

        @Override
        public List<String> getParameters() {
            ArrayList<String> params = new ArrayList<String>(this.simulationWrapper.getParameters());
            params.addAll(this.algorithmWrapper.getParameters());
            return params;
        }

        public SimulationWrapper getSimulationWrapper() {
            return this.simulationWrapper;
        }

        public AlgorithmWrapper getAlgorithmWrapper() {
            return this.algorithmWrapper;
        }
    }

    private static enum Mode {
        Average,
        StandardDeviation,
        WorstCase;

    }

    private class AlgorithmTask
    implements Callable<Void> {
        private final List<AlgorithmSimulationWrapper> algorithmSimulationWrappers;
        private final List<AlgorithmWrapper> algorithmWrappers;
        private final List<SimulationWrapper> simulationWrappers;
        private final Statistics statistics;
        private final int numGraphTypes;
        private final double[][][][] allStats;
        private final Run run;

        public AlgorithmTask(List<AlgorithmSimulationWrapper> algorithmSimulationWrappers, List<AlgorithmWrapper> algorithmWrappers, List<SimulationWrapper> simulationWrappers, Statistics statistics, int numGraphTypes, double[][][][] allStats, Run run) {
            this.algorithmSimulationWrappers = algorithmSimulationWrappers;
            this.simulationWrappers = simulationWrappers;
            this.algorithmWrappers = algorithmWrappers;
            this.statistics = statistics;
            this.numGraphTypes = numGraphTypes;
            this.allStats = allStats;
            this.run = run;
        }

        @Override
        public Void call() throws Exception {
            TimeoutComparison.this.doRun(this.algorithmSimulationWrappers, this.algorithmWrappers, this.simulationWrappers, this.statistics, this.numGraphTypes, this.allStats, this.run);
            return null;
        }

        static /* synthetic */ Run access$200(AlgorithmTask x0) {
            return x0.run;
        }
    }
}

