/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.algcomparison.simulation.Simulation;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.util.Parameters;
import java.util.ArrayList;
import java.util.List;

public abstract class ExternalAlgorithm
implements Algorithm {
    protected String path;
    protected Simulation simulation;
    protected int simIndex = -1;
    protected List<String> usedParameters = new ArrayList<String>();

    public void setPath(String path) {
        this.path = path;
    }

    public void setSimIndex(int simIndex) {
        this.simIndex = simIndex;
    }

    public Simulation getSimulation() {
        return this.simulation;
    }

    public void setSimulation(Simulation simulation) {
        this.simulation = simulation;
    }

    public abstract long getElapsedTime(DataModel var1, Parameters var2);

    @Override
    public List<String> getParameters() {
        return this.usedParameters;
    }

    public int getNumDataModels() {
        return this.simulation.getNumDataModels();
    }

    public int getIndex(DataModel dataSet) {
        int index = -1;
        for (int i = 0; i < this.getNumDataModels(); ++i) {
            if (dataSet != this.simulation.getDataModel(i)) continue;
            index = i + 1;
            break;
        }
        if (index == -1) {
            throw new IllegalArgumentException("Not a dataset for this simulation.");
        }
        return index;
    }
}

