/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.util.Parameters;
import java.util.List;
import java.util.Set;
import org.apache.commons.math3.util.FastMath;

public class FirstInflection
implements Algorithm {
    private static final long serialVersionUID = 23L;
    private final double low;
    private final double high;
    private final double increment;
    private final String parameter;
    private final Algorithm algorithm;

    public FirstInflection(Algorithm algorithm, String parameter, double low, double high, double increment) {
        if (low >= high) {
            throw new IllegalArgumentException("Must have low < high");
        }
        this.algorithm = algorithm;
        this.low = low;
        this.high = high;
        this.increment = increment;
        this.parameter = parameter;
    }

    private static double getValue(double value, Parameters parameters) {
        if (parameters.getBoolean("logScale")) {
            return (double)FastMath.round(FastMath.pow(10.0, value) * 1.0E9) / 1.0E9;
        }
        return (double)FastMath.round(value * 1.0E9) / 1.0E9;
    }

    @Override
    public Graph search(DataModel dataSet, Parameters parameters) {
        Parameters _parameters = new Parameters(parameters);
        Graph _previous = null;
        int _prevDiff = Integer.MAX_VALUE;
        double _value = 0.0;
        if (this.increment > 0.0) {
            Graph intialGraph;
            double value;
            for (value = this.low - this.increment; value <= this.high + 1.0E-7; value += this.increment) {
                double value0 = FirstInflection.getValue(value, parameters);
                _parameters.set(this.parameter, (Object)value0);
                intialGraph = this.algorithm.search(dataSet, _parameters);
                if (_previous == null) {
                    _previous = intialGraph;
                    continue;
                }
                intialGraph = GraphUtils.replaceNodes(intialGraph, _previous.getNodes());
                Set<Edge> edges1 = intialGraph.getEdges();
                int numEdges = edges1.size();
                Set<Edge> edges2 = _previous.getEdges();
                edges2.removeAll(edges1);
                int diff = edges2.size();
                System.out.println(this.parameter + " = " + _parameters.getDouble(this.parameter) + " # edges = " + numEdges + " # additional = " + diff);
                if (diff >= _prevDiff) break;
                _previous = intialGraph;
                _value = _parameters.getDouble(this.parameter);
                _prevDiff = diff;
            }
            if (_value == (double)FastMath.round((this.low + this.increment) * 1.0E9) / 1.0E9) {
                for (value = this.low; value >= Double.NEGATIVE_INFINITY; value -= this.increment) {
                    value = FirstInflection.getValue(value, parameters);
                    _parameters.set(this.parameter, (Object)value);
                    intialGraph = this.algorithm.search(dataSet, _parameters);
                    assert (_previous != null);
                    intialGraph = GraphUtils.replaceNodes(intialGraph, _previous.getNodes());
                    Set<Edge> edges1 = intialGraph.getEdges();
                    int numEdges = edges1.size();
                    Set<Edge> edges2 = intialGraph.getEdges();
                    edges2.removeAll(_previous.getEdges());
                    int diff = edges2.size();
                    System.out.println(this.parameter + " = " + _parameters.getDouble(this.parameter) + " # edges = " + numEdges + " # additional = " + diff);
                    if (diff < _prevDiff) {
                        _previous = intialGraph;
                        _value = _parameters.getDouble(this.parameter);
                        _prevDiff = diff;
                        continue;
                    }
                    break;
                }
            }
        } else {
            Graph intialGraph;
            double value;
            for (value = this.high; value >= this.low - 1.0E-7; value += this.increment) {
                double value0 = FirstInflection.getValue(value, parameters);
                _parameters.set(this.parameter, (Object)value0);
                intialGraph = this.algorithm.search(dataSet, _parameters);
                if (_previous == null) {
                    _previous = intialGraph;
                    continue;
                }
                intialGraph = GraphUtils.replaceNodes(intialGraph, _previous.getNodes());
                Set<Edge> edges1 = intialGraph.getEdges();
                int numEdges = edges1.size();
                Set<Edge> edges2 = _previous.getEdges();
                edges2.removeAll(edges1);
                int diff = edges2.size();
                System.out.println(this.parameter + " = " + _parameters.getDouble(this.parameter) + " # edges = " + numEdges + " # additional = " + diff);
                if (diff >= _prevDiff) break;
                _previous = intialGraph;
                _value = _parameters.getDouble(this.parameter);
                _prevDiff = diff;
            }
            if (_value == (double)FastMath.round((this.high - this.increment) * 1.0E9) / 1.0E9) {
                for (value = this.low; value >= Double.NEGATIVE_INFINITY; value -= this.increment) {
                    value = FirstInflection.getValue(value, parameters);
                    _parameters.set(this.parameter, (Object)value);
                    intialGraph = this.algorithm.search(dataSet, _parameters);
                    assert (_previous != null);
                    intialGraph = GraphUtils.replaceNodes(intialGraph, _previous.getNodes());
                    Set<Edge> edges1 = intialGraph.getEdges();
                    int numEdges = edges1.size();
                    Set<Edge> edges2 = intialGraph.getEdges();
                    edges2.removeAll(_previous.getEdges());
                    int diff = edges2.size();
                    System.out.println(this.parameter + " = " + _parameters.getDouble(this.parameter) + " # edges = " + numEdges + " # additional = " + diff);
                    if (diff < _prevDiff) {
                        _previous = intialGraph;
                        _value = _parameters.getDouble(this.parameter);
                        _prevDiff = diff;
                        continue;
                    }
                    break;
                }
            }
        }
        System.out.println(this.parameter + " = " + _value);
        return _previous;
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        return this.algorithm.getComparisonGraph(graph);
    }

    @Override
    public String getDescription() {
        return "First inflection for " + this.algorithm.getDescription() + " parameter = " + this.parameter;
    }

    @Override
    public DataType getDataType() {
        return this.algorithm.getDataType();
    }

    @Override
    public List<String> getParameters() {
        List<String> parameters = this.algorithm.getParameters();
        parameters.add("depth");
        parameters.add("verbose");
        return parameters;
    }
}

