/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.data.BootstrapSampler;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.util.ForkJoinPoolInstance;
import edu.cmu.tetrad.util.Parameters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveAction;

public class StabilitySelection
implements Algorithm {
    private static final long serialVersionUID = 23L;
    private final Algorithm algorithm;

    public StabilitySelection(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public Graph search(DataModel dataSet, Parameters parameters) {
        DataSet _dataSet = (DataSet)dataSet;
        double percentageB = parameters.getDouble("percentSubsampleSize");
        int numSubsamples = parameters.getInt("numSubsamples");
        HashMap<Edge, Integer> counts = new HashMap<Edge, Integer>();
        ArrayList graphs = new ArrayList();
        ForkJoinPool pool = ForkJoinPoolInstance.getInstance().getPool();
        int chunk = 2;
        class StabilityAction
        extends RecursiveAction {
            private final int chunk;
            private final int from;
            private final int to;
            final /* synthetic */ DataSet val$_dataSet;
            final /* synthetic */ double val$percentageB;
            final /* synthetic */ Parameters val$parameters;
            final /* synthetic */ List val$graphs;

            StabilityAction(int chunk, int from, int to) {
                this.val$_dataSet = dataSet;
                this.val$percentageB = d;
                this.val$parameters = parameters;
                this.val$graphs = list;
                this.chunk = chunk;
                this.from = from;
                this.to = to;
            }

            @Override
            protected void compute() {
                if (this.to - this.from <= this.chunk) {
                    for (int s = this.from; s < this.to; ++s) {
                        BootstrapSampler sampler = new BootstrapSampler();
                        sampler.setWithoutReplacements(true);
                        DataSet sample = sampler.sample(this.val$_dataSet, (int)(this.val$percentageB * (double)this.val$_dataSet.getNumRows()));
                        Graph graph = StabilitySelection.this.algorithm.search(sample, this.val$parameters);
                        this.val$graphs.add(graph);
                    }
                } else {
                    int mid = (this.to + this.from) / 2;
                    StabilityAction left = new StabilityAction(this.chunk, this.from, mid);
                    StabilityAction right = new StabilityAction(this.chunk, mid, this.to);
                    left.fork();
                    right.compute();
                    left.join();
                }
            }
        }
        pool.invoke(new StabilityAction(2, 0, numSubsamples));
        for (Graph graph : graphs) {
            for (Edge edge : graph.getEdges()) {
                this.increment(edge, counts);
            }
        }
        EdgeListGraph outputGraph = new EdgeListGraph(dataSet.getVariables());
        double percentStability = parameters.getDouble("percentStability");
        for (Edge edge : counts.keySet()) {
            if (!((double)((Integer)counts.get(edge)).intValue() > percentStability * (double)numSubsamples)) continue;
            outputGraph.addEdge(edge);
        }
        return outputGraph;
    }

    private void increment(Edge edge, Map<Edge, Integer> counts) {
        counts.putIfAbsent(edge, 0);
        counts.put(edge, counts.get(edge) + 1);
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        return this.algorithm.getComparisonGraph(graph);
    }

    @Override
    public String getDescription() {
        return "Stability selection for " + this.algorithm.getDescription();
    }

    @Override
    public DataType getDataType() {
        return this.algorithm.getDataType();
    }

    @Override
    public List<String> getParameters() {
        List<String> parameters = this.algorithm.getParameters();
        parameters.add("depth");
        parameters.add("verbose");
        parameters.add("numSubsamples");
        parameters.add("percentSubsampleSize");
        parameters.add("percentStability");
        return parameters;
    }
}

