/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.cluster;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.algcomparison.algorithm.cluster.ClusterAlgorithm;
import edu.cmu.tetrad.algcomparison.utils.HasKnowledge;
import edu.cmu.tetrad.annotation.AlgType;
import edu.cmu.tetrad.annotation.Bootstrapping;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphTransforms;
import edu.cmu.tetrad.search.Ftfc;
import edu.cmu.tetrad.util.Parameters;
import edu.pitt.dbmi.algo.resampling.GeneralResamplingTest;
import java.util.ArrayList;
import java.util.List;

@edu.cmu.tetrad.annotation.Algorithm(name="FTFC", command="ftfc", algoType=AlgType.search_for_structure_over_latents)
@Bootstrapping
public class Ftfc
implements Algorithm,
HasKnowledge,
ClusterAlgorithm {
    private static final long serialVersionUID = 23L;
    private Knowledge knowledge = new Knowledge();

    @Override
    public Graph search(DataModel dataSet, Parameters parameters) {
        if (parameters.getInt("numberResampling") < 1) {
            ICovarianceMatrix cov;
            if (dataSet instanceof DataSet) {
                boolean precomputeCovariances = parameters.getBoolean("precomputeCovariances");
                cov = SimpleDataLoader.getCovarianceMatrix(dataSet, precomputeCovariances);
            } else if (dataSet instanceof ICovarianceMatrix) {
                cov = (ICovarianceMatrix)dataSet;
            } else {
                throw new IllegalArgumentException("Expected a dataset or a covariance matrix.");
            }
            double alpha = parameters.getDouble("alpha");
            boolean gap = parameters.getBoolean("useGap", true);
            Ftfc.Algorithm algorithm = gap ? Ftfc.Algorithm.GAP : Ftfc.Algorithm.SAG;
            edu.cmu.tetrad.search.Ftfc search = new edu.cmu.tetrad.search.Ftfc(cov, algorithm, alpha);
            search.setVerbose(parameters.getBoolean("verbose"));
            return search.search();
        }
        Ftfc algorithm = new Ftfc();
        DataSet data = (DataSet)dataSet;
        GeneralResamplingTest search = new GeneralResamplingTest(data, algorithm, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        search.setKnowledge(this.knowledge);
        search.setParameters(parameters);
        search.setVerbose(parameters.getBoolean("verbose"));
        return search.search();
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        EdgeListGraph dag = new EdgeListGraph(graph);
        return GraphTransforms.cpdagForDag(dag);
    }

    @Override
    public String getDescription() {
        return "FTFC (Find Two Factor Clusters)";
    }

    @Override
    public DataType getDataType() {
        return DataType.Continuous;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("alpha");
        parameters.add("useWishart");
        parameters.add("useGap");
        parameters.add("precomputeCovariances");
        parameters.add("verbose");
        return parameters;
    }

    @Override
    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }
}

