/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.continuous.dag;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.algcomparison.algorithm.ReturnsBootstrapGraphs;
import edu.cmu.tetrad.annotation.AlgType;
import edu.cmu.tetrad.annotation.Bootstrapping;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.pitt.dbmi.algo.resampling.GeneralResamplingTest;
import java.util.ArrayList;
import java.util.List;

@edu.cmu.tetrad.annotation.Algorithm(name="DAGMA", command="dagma", algoType=AlgType.forbid_latent_common_causes, dataType={DataType.Continuous})
@Bootstrapping
public class Dagma
implements Algorithm,
ReturnsBootstrapGraphs {
    private static final long serialVersionUID = 23L;
    private List<Graph> bootstrapGraphs = new ArrayList<Graph>();

    @Override
    public Graph search(DataModel dataSet, Parameters parameters) {
        if (parameters.getInt("numberResampling") < 1) {
            DataSet data = SimpleDataLoader.getContinuousDataSet(dataSet);
            edu.cmu.tetrad.search.Dagma search = new edu.cmu.tetrad.search.Dagma(data);
            search.setLambda1(parameters.getDouble("lambda1"));
            search.setWThreshold(parameters.getDouble("wThreshold"));
            search.setCpdag(parameters.getBoolean("cpdag"));
            Graph graph = search.search();
            TetradLogger.getInstance().forceLogMessage(graph.toString());
            return graph;
        }
        Dagma algorithm = new Dagma();
        DataSet data = (DataSet)dataSet;
        GeneralResamplingTest search = new GeneralResamplingTest(data, algorithm, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        search.setParameters(parameters);
        search.setVerbose(parameters.getBoolean("verbose"));
        if (parameters.getBoolean("saveBootstrapGraphs")) {
            this.bootstrapGraphs = search.getGraphs();
        }
        return search.search();
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        return new EdgeListGraph(graph);
    }

    @Override
    public String getDescription() {
        return "DAGMA (DAGs via M-matrices for Acyclicity)";
    }

    @Override
    public DataType getDataType() {
        return DataType.Continuous;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("verbose");
        parameters.add("lambda1");
        parameters.add("wThreshold");
        parameters.add("cpdag");
        return parameters;
    }

    @Override
    public List<Graph> getBootstrapGraphs() {
        return this.bootstrapGraphs;
    }
}

