/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.continuous.dag;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.algcomparison.algorithm.ReturnsBootstrapGraphs;
import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.algcomparison.utils.UsesScoreWrapper;
import edu.cmu.tetrad.annotation.AlgType;
import edu.cmu.tetrad.annotation.Bootstrapping;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.score.Score;
import edu.cmu.tetrad.search.utils.LogUtilsSearch;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.pitt.dbmi.algo.resampling.GeneralResamplingTest;
import java.util.ArrayList;
import java.util.List;

@edu.cmu.tetrad.annotation.Algorithm(name="Direct-LiNGAM", command="direct-lingam", algoType=AlgType.forbid_latent_common_causes, dataType={DataType.Continuous})
@Bootstrapping
public class DirectLingam
implements Algorithm,
UsesScoreWrapper,
ReturnsBootstrapGraphs {
    private static final long serialVersionUID = 23L;
    private ScoreWrapper score;
    private List<Graph> bootstrapGraphs = new ArrayList<Graph>();

    public DirectLingam() {
    }

    public DirectLingam(ScoreWrapper score) {
        this.score = score;
    }

    @Override
    public Graph search(DataModel dataSet, Parameters parameters) {
        if (parameters.getInt("numberResampling") < 1) {
            DataSet data = SimpleDataLoader.getContinuousDataSet(dataSet);
            Score score = this.score.getScore(dataSet, parameters);
            edu.cmu.tetrad.search.DirectLingam search = new edu.cmu.tetrad.search.DirectLingam(data, score);
            Graph graph = search.search();
            TetradLogger.getInstance().forceLogMessage(graph.toString());
            LogUtilsSearch.stampWithBic(graph, dataSet);
            return graph;
        }
        DirectLingam algorithm = new DirectLingam();
        DataSet data = (DataSet)dataSet;
        GeneralResamplingTest search = new GeneralResamplingTest(data, algorithm, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        search.setParameters(parameters);
        search.setVerbose(parameters.getBoolean("verbose"));
        if (parameters.getBoolean("saveBootstrapGraphs")) {
            this.bootstrapGraphs = search.getGraphs();
        }
        return search.search();
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        return new EdgeListGraph(graph);
    }

    @Override
    public String getDescription() {
        return "Direct-LiNGAM (Direct Linear Non-Gaussian Acyclic Model";
    }

    @Override
    public DataType getDataType() {
        return DataType.Continuous;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("verbose");
        return parameters;
    }

    @Override
    public List<Graph> getBootstrapGraphs() {
        return this.bootstrapGraphs;
    }

    @Override
    public ScoreWrapper getScoreWrapper() {
        return this.score;
    }

    @Override
    public void setScoreWrapper(ScoreWrapper score) {
        this.score = score;
    }
}

