/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.continuous.dag;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.algcomparison.algorithm.ReturnsBootstrapGraphs;
import edu.cmu.tetrad.annotation.AlgType;
import edu.cmu.tetrad.annotation.Bootstrapping;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.pitt.dbmi.algo.resampling.GeneralResamplingTest;
import java.util.ArrayList;
import java.util.List;

@edu.cmu.tetrad.annotation.Algorithm(name="ICA-LiNG-D", command="ica-ling-d", algoType=AlgType.forbid_latent_common_causes, dataType={DataType.Continuous})
@Bootstrapping
public class IcaLingD
implements Algorithm,
ReturnsBootstrapGraphs {
    private static final long serialVersionUID = 23L;
    private List<Graph> bootstrapGraphs = new ArrayList<Graph>();

    @Override
    public Graph search(DataModel dataSet, Parameters parameters) {
        if (parameters.getInt("numberResampling") < 1) {
            DataSet data = SimpleDataLoader.getContinuousDataSet(dataSet);
            int maxIter = parameters.getInt("fastIcaMaxIter");
            double alpha = parameters.getDouble("fastIcaA");
            double tol = parameters.getDouble("fastIcaTolerance");
            double bThreshold = parameters.getDouble("thresholdBHat");
            double spineThreshold = parameters.getDouble("thresholdSpine");
            Matrix W = edu.cmu.tetrad.search.IcaLingD.estimateW(data, maxIter, tol, alpha);
            edu.cmu.tetrad.search.IcaLingD icaLingD = new edu.cmu.tetrad.search.IcaLingD();
            icaLingD.setBThreshold(bThreshold);
            icaLingD.setSpineThreshold(spineThreshold);
            List<Matrix> bHats = icaLingD.fitW(W);
            int count = 0;
            for (Matrix bHat : bHats) {
                TetradLogger.getInstance().forceLogMessage("LiNG-D Model #" + ++count);
                Graph graph = edu.cmu.tetrad.search.IcaLingD.makeGraph(bHat, dataSet.getVariables());
                TetradLogger.getInstance().forceLogMessage(bHat.toString());
                TetradLogger.getInstance().forceLogMessage(graph.toString());
                TetradLogger.getInstance().forceLogMessage("Stable = " + edu.cmu.tetrad.search.IcaLingD.isStable(bHat));
            }
            if (bHats.size() > 0) {
                return edu.cmu.tetrad.search.IcaLingD.makeGraph(bHats.get(0), dataSet.getVariables());
            }
            throw new IllegalArgumentException("LiNG-D couldn't find a model.");
        }
        IcaLingD algorithm = new IcaLingD();
        DataSet data = (DataSet)dataSet;
        GeneralResamplingTest search = new GeneralResamplingTest(data, algorithm, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        search.setParameters(parameters);
        search.setVerbose(parameters.getBoolean("verbose"));
        if (parameters.getBoolean("saveBootstrapGraphs")) {
            this.bootstrapGraphs = search.getGraphs();
        }
        return search.search();
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        return new EdgeListGraph(graph);
    }

    @Override
    public String getDescription() {
        return "LiNG-D (Linear Non-Gaussian Discovery";
    }

    @Override
    public DataType getDataType() {
        return DataType.Continuous;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("verbose");
        parameters.add("fastIcaA");
        parameters.add("fastIcaMaxIter");
        parameters.add("fastIcaTolerance");
        parameters.add("thresholdBHat");
        parameters.add("thresholdSpine");
        return parameters;
    }

    @Override
    public List<Graph> getBootstrapGraphs() {
        return this.bootstrapGraphs;
    }
}

