/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.continuous.dag;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.algcomparison.algorithm.ReturnsBootstrapGraphs;
import edu.cmu.tetrad.annotation.AlgType;
import edu.cmu.tetrad.annotation.Bootstrapping;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.IcaLingD;
import edu.cmu.tetrad.search.utils.LogUtilsSearch;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.pitt.dbmi.algo.resampling.GeneralResamplingTest;
import java.util.ArrayList;
import java.util.List;

@edu.cmu.tetrad.annotation.Algorithm(name="ICA-LiNGAM", command="ica-lingam", algoType=AlgType.forbid_latent_common_causes, dataType={DataType.Continuous})
@Bootstrapping
public class IcaLingam
implements Algorithm,
ReturnsBootstrapGraphs {
    private static final long serialVersionUID = 23L;
    private List<Graph> bootstrapGraphs = new ArrayList<Graph>();

    @Override
    public Graph search(DataModel dataSet, Parameters parameters) {
        if (parameters.getInt("numberResampling") < 1) {
            DataSet data = SimpleDataLoader.getContinuousDataSet(dataSet);
            int maxIter = parameters.getInt("fastIcaMaxIter");
            double alpha = parameters.getDouble("fastIcaA");
            double tol = parameters.getDouble("fastIcaTolerance");
            Matrix W = IcaLingD.estimateW(data, maxIter, tol, alpha);
            edu.cmu.tetrad.search.IcaLingam icaLingam = new edu.cmu.tetrad.search.IcaLingam();
            icaLingam.setBThreshold(parameters.getDouble("thresholdBHat"));
            icaLingam.setAcyclicityGuaranteed(parameters.getBoolean("guaranteeAcyclic"));
            Matrix bHat = icaLingam.fitW(W);
            Graph graph = IcaLingD.makeGraph(bHat, data.getVariables());
            TetradLogger.getInstance().forceLogMessage(bHat.toString());
            TetradLogger.getInstance().forceLogMessage(graph.toString());
            LogUtilsSearch.stampWithBic(graph, dataSet);
            return graph;
        }
        IcaLingam algorithm = new IcaLingam();
        DataSet data = (DataSet)dataSet;
        GeneralResamplingTest search = new GeneralResamplingTest(data, algorithm, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        search.setParameters(parameters);
        search.setVerbose(parameters.getBoolean("verbose"));
        if (parameters.getBoolean("saveBootstrapGraphs")) {
            this.bootstrapGraphs = search.getGraphs();
        }
        return search.search();
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        return new EdgeListGraph(graph);
    }

    @Override
    public String getDescription() {
        return "ICA-LiNGAM (ICA Linear Non-Gaussian Acyclic Model";
    }

    @Override
    public DataType getDataType() {
        return DataType.Continuous;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("verbose");
        parameters.add("fastIcaMaxIter");
        parameters.add("fastIcaA");
        parameters.add("fastIcaTolerance");
        parameters.add("thresholdBHat");
        parameters.add("guaranteeAcyclic");
        return parameters;
    }

    @Override
    public List<Graph> getBootstrapGraphs() {
        return this.bootstrapGraphs;
    }
}

