/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.external;

import edu.cmu.tetrad.algcomparison.algorithm.ExternalAlgorithm;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.Parameters;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class ExternalAlgorithmPcalgGes
extends ExternalAlgorithm {
    private static final long serialVersionUID = 23L;
    private final String extDir;
    private final String shortDescription;

    public ExternalAlgorithmPcalgGes(String extDir) {
        this.extDir = extDir;
        this.shortDescription = new File(extDir).getName().replace("_", " ");
    }

    public ExternalAlgorithmPcalgGes(String extDir, String shortDecription) {
        this.extDir = extDir;
        this.shortDescription = shortDecription;
    }

    @Override
    public Graph search(DataModel dataSet, Parameters parameters) {
        int index = this.getIndex(dataSet);
        File nodes = new File(this.path, "/results/" + this.extDir + "/" + (this.simIndex + 1) + "/nodes." + index + ".txt");
        System.out.println(nodes.getAbsolutePath());
        ArrayList<Node> vars = new ArrayList<Node>();
        try {
            String name;
            BufferedReader r = new BufferedReader(new FileReader(nodes));
            while ((name = r.readLine()) != null) {
                GraphNode node = new GraphNode(name.trim());
                vars.add(node);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        File inEdges = new File(this.path, "/results/" + this.extDir + "/" + (this.simIndex + 1) + "/in.edges." + index + ".txt");
        try {
            BufferedReader r = new BufferedReader(new FileReader(inEdges));
            EdgeListGraph graph = new EdgeListGraph(vars);
            for (Node var : vars) {
                String[] tokens;
                String line = r.readLine();
                for (String token : tokens = line.split(",")) {
                    String trim = token.trim();
                    if (trim.isEmpty()) continue;
                    int j = Integer.parseInt(trim) - 1;
                    Node v2 = (Node)vars.get(j);
                    if (!graph.isAdjacentTo(v2, var)) {
                        graph.addDirectedEdge(v2, var);
                        continue;
                    }
                    graph.removeEdge(v2, var);
                    graph.addUndirectedEdge(v2, var);
                }
            }
            return graph;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Could not parse graph.");
        }
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        return new EdgeListGraph(graph);
    }

    @Override
    public String getDescription() {
        if (this.shortDescription == null) {
            return "Load data from " + this.path + "/" + this.extDir;
        }
        return this.shortDescription;
    }

    @Override
    public DataType getDataType() {
        return DataType.Continuous;
    }

    @Override
    public long getElapsedTime(DataModel dataSet, Parameters parameters) {
        int index = this.getIndex(dataSet);
        File file = new File(this.path, "/elapsed/" + this.extDir + "/" + (this.simIndex + 1) + "/graph." + index + ".txt");
        try {
            BufferedReader r = new BufferedReader(new FileReader(file));
            String l = r.readLine();
            return Long.parseLong(l);
        }
        catch (IOException e) {
            return -99L;
        }
    }
}

