/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.mixed;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.annotation.AlgType;
import edu.cmu.tetrad.annotation.Bootstrapping;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.Parameters;
import edu.pitt.dbmi.algo.resampling.GeneralResamplingTest;
import java.util.ArrayList;
import java.util.List;

@edu.cmu.tetrad.annotation.Algorithm(name="MGM", command="mgm", algoType=AlgType.produce_undirected_graphs)
@Bootstrapping
public class Mgm
implements Algorithm {
    private static final long serialVersionUID = 23L;

    @Override
    public Graph search(DataModel ds, Parameters parameters) {
        if (!(ds instanceof DataSet)) {
            throw new IllegalArgumentException("Expecting tabular data for MGM.");
        }
        DataSet _data = (DataSet)ds;
        for (int j = 0; j < _data.getNumColumns(); ++j) {
            for (int i = 0; i < _data.getNumRows(); ++i) {
                if (!(ds.getVariables().get(j) instanceof ContinuousVariable ? Double.isNaN(_data.getDouble(i, j)) : ds.getVariables().get(j) instanceof DiscreteVariable && _data.getDouble(i, j) == -99.0)) continue;
                throw new IllegalArgumentException("Please remove or impute missing values.");
            }
        }
        List<Node> variables = ds.getVariables();
        boolean hasContinuous = false;
        boolean hasDiscrete = false;
        for (Node node : variables) {
            if (node instanceof ContinuousVariable) {
                hasContinuous = true;
            }
            if (!(node instanceof DiscreteVariable)) continue;
            hasDiscrete = true;
        }
        if (!hasContinuous || !hasDiscrete) {
            throw new IllegalArgumentException("You need at least one continuous and one discrete variable to run MGM.");
        }
        if (parameters.getInt("numberResampling") < 1) {
            DataSet _ds = SimpleDataLoader.getMixedDataSet(ds);
            double mgmParam1 = parameters.getDouble("mgmParam1");
            double mgmParam2 = parameters.getDouble("mgmParam2");
            double mgmParam3 = parameters.getDouble("mgmParam3");
            double[] lambda = new double[]{mgmParam1, mgmParam2, mgmParam3};
            edu.pitt.csb.mgm.Mgm m = new edu.pitt.csb.mgm.Mgm(_ds, lambda);
            return m.search();
        }
        Mgm algorithm = new Mgm();
        DataSet data = (DataSet)ds;
        GeneralResamplingTest search = new GeneralResamplingTest(data, algorithm, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        search.setParameters(parameters);
        search.setVerbose(parameters.getBoolean("verbose"));
        return search.search();
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        return GraphUtils.undirectedGraph(graph);
    }

    @Override
    public String getDescription() {
        return "Returns the output of the MGM (Mixed Graphical Model) algorithm (a Markov random field)";
    }

    @Override
    public DataType getDataType() {
        return DataType.Mixed;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("mgmParam1");
        parameters.add("mgmParam2");
        parameters.add("mgmParam3");
        parameters.add("verbose");
        return parameters;
    }
}

