/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.multi;

import edu.cmu.tetrad.algcomparison.algorithm.MultiDataSetAlgorithm;
import edu.cmu.tetrad.algcomparison.independence.IndependenceWrapper;
import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.algcomparison.utils.HasKnowledge;
import edu.cmu.tetrad.algcomparison.utils.TakesIndependenceWrapper;
import edu.cmu.tetrad.annotation.Bootstrapping;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataTransforms;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.Fask;
import edu.cmu.tetrad.util.Parameters;
import edu.pitt.dbmi.algo.resampling.GeneralResamplingTest;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Bootstrapping
public class FaskConcatenated
implements MultiDataSetAlgorithm,
HasKnowledge,
TakesIndependenceWrapper {
    private static final long serialVersionUID = 23L;
    private IndependenceWrapper test;
    private ScoreWrapper score;
    private Knowledge knowledge = new Knowledge();

    public FaskConcatenated() {
    }

    public FaskConcatenated(ScoreWrapper score, IndependenceWrapper test) {
        this.score = score;
        this.test = test;
    }

    @Override
    public Graph search(List<DataModel> dataSets, Parameters parameters) {
        if (parameters.getInt("numberResampling") < 1) {
            ArrayList<DataSet> centered = new ArrayList<DataSet>();
            for (DataModel dataSet : dataSets) {
                centered.add(DataTransforms.standardizeData((DataSet)dataSet));
            }
            DataSet dataSet = DataTransforms.concatenate(centered);
            dataSet.setNumberFormat(new DecimalFormat("0.000000000000000000"));
            Fask search = new Fask(dataSet, this.score.getScore(dataSet, parameters), this.test.getTest(dataSet, parameters));
            search.setDepth(parameters.getInt("depth"));
            search.setSkewEdgeThreshold(parameters.getDouble("skewEdgeThreshold"));
            search.setKnowledge(this.knowledge);
            return search.search();
        }
        FaskConcatenated algorithm = new FaskConcatenated(this.score, this.test);
        ArrayList<DataSet> datasets = new ArrayList<DataSet>();
        for (DataModel dataModel : dataSets) {
            datasets.add((DataSet)dataModel);
        }
        GeneralResamplingTest search = new GeneralResamplingTest(datasets, algorithm, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        search.setKnowledge(this.knowledge);
        search.setScoreWrapper(this.score);
        search.setParameters(parameters);
        search.setVerbose(parameters.getBoolean("verbose"));
        return search.search();
    }

    @Override
    public void setScoreWrapper(ScoreWrapper score) {
    }

    @Override
    public void setIndTestWrapper(IndependenceWrapper test) {
    }

    @Override
    public Graph search(DataModel dataSet, Parameters parameters) {
        if (parameters.getInt("numberResampling") < 1) {
            return this.search(Collections.singletonList(SimpleDataLoader.getContinuousDataSet(dataSet)), parameters);
        }
        FaskConcatenated algorithm = new FaskConcatenated(this.score, this.test);
        List<DataSet> dataSets = Collections.singletonList(SimpleDataLoader.getContinuousDataSet(dataSet));
        GeneralResamplingTest search = new GeneralResamplingTest(dataSets, algorithm, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        search.setKnowledge(this.knowledge);
        search.setScoreWrapper(this.score);
        search.setParameters(parameters);
        search.setVerbose(parameters.getBoolean("verbose"));
        return search.search();
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        return new EdgeListGraph(graph);
    }

    @Override
    public String getDescription() {
        return "FASK Concatenated";
    }

    @Override
    public DataType getDataType() {
        return DataType.Continuous;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("depth");
        parameters.add("twoCycleAlpha");
        parameters.add("skewEdgeThreshold");
        parameters.add("numRuns");
        parameters.add("randomSelectionSize");
        parameters.add("verbose");
        return parameters;
    }

    @Override
    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    @Override
    public IndependenceWrapper getIndependenceWrapper() {
        return this.test;
    }

    @Override
    public void setIndependenceWrapper(IndependenceWrapper independenceWrapper) {
        this.test = independenceWrapper;
    }
}

