/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.multi;

import edu.cmu.tetrad.algcomparison.algorithm.MultiDataSetAlgorithm;
import edu.cmu.tetrad.algcomparison.independence.IndependenceWrapper;
import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.algcomparison.utils.HasKnowledge;
import edu.cmu.tetrad.algcomparison.utils.TakesIndependenceWrapper;
import edu.cmu.tetrad.annotation.AlgType;
import edu.cmu.tetrad.annotation.Algorithm;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.Fci;
import edu.cmu.tetrad.search.IndTestIod;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.utils.TsUtils;
import edu.cmu.tetrad.util.Parameters;
import edu.pitt.dbmi.algo.resampling.GeneralResamplingTest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

@Algorithm(name="FCI-IOD", command="fci-iod", algoType=AlgType.forbid_latent_common_causes, dataType={DataType.All})
public class FciIod
implements MultiDataSetAlgorithm,
HasKnowledge,
TakesIndependenceWrapper {
    private static final long serialVersionUID = 23L;
    private Knowledge knowledge = new Knowledge();
    private IndependenceWrapper test;

    public FciIod(IndependenceWrapper test) {
        this.test = test;
    }

    public FciIod() {
    }

    @Override
    public Graph search(List<DataModel> dataSets, Parameters parameters) {
        ArrayList<DataModel> _dataSets = new ArrayList<DataModel>();
        if (parameters.getInt("timeLag") > 0) {
            for (DataModel dataModel : dataSets) {
                DataSet timeSeries = TsUtils.createLagData((DataSet)dataModel, parameters.getInt("timeLag"));
                if (dataModel.getName() != null) {
                    timeSeries.setName(dataModel.getName());
                }
                _dataSets.add(timeSeries);
            }
            dataSets = _dataSets;
        }
        ArrayList<IndependenceTest> tests = new ArrayList<IndependenceTest>();
        for (DataModel dataModel : dataSets) {
            IndependenceTest s = this.test.getTest(dataModel, parameters);
            tests.add(s);
        }
        IndTestIod indTestIod = new IndTestIod(tests);
        Fci search = new Fci(indTestIod);
        search.setDepth(parameters.getInt("depth"));
        search.setKnowledge(this.knowledge);
        search.setMaxPathLength(parameters.getInt("maxPathLength"));
        search.setCompleteRuleSetUsed(parameters.getBoolean("completeRuleSetUsed"));
        search.setPossibleMsepSearchDone(parameters.getBoolean("possibleMsepDone"));
        search.setDoDiscriminatingPathRule(parameters.getBoolean("doDiscriminatingPathRule"));
        search.setVerbose(parameters.getBoolean("verbose"));
        search.setStable(parameters.getBoolean("stableFAS"));
        return search.search();
    }

    @Override
    public void setScoreWrapper(ScoreWrapper score) {
    }

    @Override
    public void setIndTestWrapper(IndependenceWrapper test) {
        this.test = test;
    }

    @Override
    public Graph search(DataModel dataSet, Parameters parameters) {
        if (parameters.getInt("numberResampling") < 1) {
            return this.search(Collections.singletonList(SimpleDataLoader.getMixedDataSet(dataSet)), parameters);
        }
        FciIod images = new FciIod();
        List<DataSet> dataSets = Collections.singletonList(SimpleDataLoader.getMixedDataSet(dataSet));
        GeneralResamplingTest search = new GeneralResamplingTest(dataSets, images, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        search.setParameters(parameters);
        search.setVerbose(parameters.getBoolean("verbose"));
        return search.search();
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        return new EdgeListGraph(graph);
    }

    @Override
    public String getDescription() {
        return "FCI-IOD";
    }

    @Override
    public DataType getDataType() {
        return DataType.All;
    }

    @Override
    public List<String> getParameters() {
        LinkedList<String> parameters = new LinkedList<String>(this.test.getParameters());
        parameters.add("depth");
        parameters.add("stableFAS");
        parameters.add("maxPathLength");
        parameters.add("possibleMsepDone");
        parameters.add("doDiscriminatingPathRule");
        parameters.add("completeRuleSetUsed");
        parameters.add("timeLag");
        parameters.add("verbose");
        return parameters;
    }

    @Override
    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    @Override
    public IndependenceWrapper getIndependenceWrapper() {
        return this.test;
    }

    @Override
    public void setIndependenceWrapper(IndependenceWrapper test) {
        this.test = test;
    }
}

