/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.multi;

import edu.cmu.tetrad.algcomparison.algorithm.MultiDataSetAlgorithm;
import edu.cmu.tetrad.algcomparison.independence.IndependenceWrapper;
import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.algcomparison.score.SemBicScore;
import edu.cmu.tetrad.algcomparison.utils.HasKnowledge;
import edu.cmu.tetrad.algcomparison.utils.UsesScoreWrapper;
import edu.cmu.tetrad.annotation.AlgType;
import edu.cmu.tetrad.annotation.Algorithm;
import edu.cmu.tetrad.annotation.Bootstrapping;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.Boss;
import edu.cmu.tetrad.search.Fges;
import edu.cmu.tetrad.search.PermutationSearch;
import edu.cmu.tetrad.search.score.ImagesScore;
import edu.cmu.tetrad.search.score.Score;
import edu.cmu.tetrad.search.utils.TsUtils;
import edu.cmu.tetrad.util.Parameters;
import edu.pitt.dbmi.algo.resampling.GeneralResamplingTest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

@Algorithm(name="IMaGES", command="images", algoType=AlgType.forbid_latent_common_causes, dataType={DataType.All})
@Bootstrapping
public class Images
implements MultiDataSetAlgorithm,
HasKnowledge,
UsesScoreWrapper {
    private static final long serialVersionUID = 23L;
    private Knowledge knowledge = new Knowledge();
    private ScoreWrapper score = new SemBicScore();

    public Images(ScoreWrapper score) {
        this.score = score;
    }

    public Images() {
    }

    @Override
    public Graph search(List<DataModel> dataSets, Parameters parameters) {
        int meta = parameters.getInt("imagesMetaAlg");
        if (parameters.getInt("numberResampling") < 1) {
            ArrayList<DataModel> _dataSets = new ArrayList<DataModel>();
            if (parameters.getInt("timeLag") > 0) {
                for (DataModel dataModel : dataSets) {
                    DataSet dataSet = TsUtils.createLagData((DataSet)dataModel, parameters.getInt("timeLag"));
                    if (dataModel.getName() != null) {
                        dataSet.setName(dataModel.getName());
                    }
                    _dataSets.add(dataSet);
                }
                dataSets = _dataSets;
            }
            ArrayList<Score> scores = new ArrayList<Score>();
            for (DataModel dataModel : dataSets) {
                Score s = this.score.getScore(dataModel, parameters);
                scores.add(s);
            }
            ImagesScore imagesScore = new ImagesScore(scores);
            if (meta == 1) {
                Fges fges = new Fges(imagesScore);
                fges.setKnowledge(this.knowledge);
                fges.setVerbose(parameters.getBoolean("verbose"));
                return fges.search();
            }
            if (meta == 2) {
                PermutationSearch permutationSearch = new PermutationSearch(new Boss(imagesScore));
                permutationSearch.setKnowledge(this.knowledge);
                return permutationSearch.search();
            }
            throw new IllegalArgumentException("Unrecognized meta option: " + meta);
        }
        Images imagesSemBic = new Images();
        ArrayList<DataSet> dataSets2 = new ArrayList<DataSet>();
        for (DataModel dataModel : dataSets) {
            dataSets2.add((DataSet)dataModel);
        }
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        if (parameters.getInt("timeLag") > 0) {
            for (DataSet dataSet : dataSets2) {
                DataSet timeSeries = TsUtils.createLagData(dataSet, parameters.getInt("timeLag"));
                if (dataSet.getName() != null) {
                    timeSeries.setName(dataSet.getName());
                }
                arrayList.add(timeSeries);
            }
            dataSets2 = arrayList;
        }
        GeneralResamplingTest generalResamplingTest = new GeneralResamplingTest(dataSets2, imagesSemBic, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        generalResamplingTest.setParameters(parameters);
        generalResamplingTest.setVerbose(parameters.getBoolean("verbose"));
        generalResamplingTest.setKnowledge(this.knowledge);
        generalResamplingTest.setScoreWrapper(this.score);
        return generalResamplingTest.search();
    }

    @Override
    public Graph search(DataModel dataSet, Parameters parameters) {
        if (parameters.getInt("numberResampling") < 1) {
            return this.search(Collections.singletonList(SimpleDataLoader.getMixedDataSet(dataSet)), parameters);
        }
        Images images = new Images();
        List<DataSet> dataSets = Collections.singletonList(SimpleDataLoader.getMixedDataSet(dataSet));
        GeneralResamplingTest search = new GeneralResamplingTest(dataSets, images, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        if (this.score == null) {
            System.out.println();
        }
        search.setParameters(parameters);
        search.setVerbose(parameters.getBoolean("verbose"));
        search.setScoreWrapper(this.score);
        return search.search();
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        return new EdgeListGraph(graph);
    }

    @Override
    public String getDescription() {
        return "IMaGES";
    }

    @Override
    public DataType getDataType() {
        return DataType.All;
    }

    @Override
    public List<String> getParameters() {
        LinkedList<String> parameters = new LinkedList<String>();
        parameters.addAll(new SemBicScore().getParameters());
        parameters.addAll(new edu.cmu.tetrad.algcomparison.algorithm.oracle.cpdag.Fges().getParameters());
        parameters.add("randomSelectionSize");
        parameters.add("timeLag");
        parameters.add("imagesMetaAlg");
        parameters.add("verbose");
        return parameters;
    }

    @Override
    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    @Override
    public ScoreWrapper getScoreWrapper() {
        return this.score;
    }

    @Override
    public void setScoreWrapper(ScoreWrapper score) {
        this.score = score;
    }

    @Override
    public void setIndTestWrapper(IndependenceWrapper test) {
    }
}

