/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.oracle.cpdag;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.algcomparison.algorithm.ReturnsBootstrapGraphs;
import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.algcomparison.utils.HasKnowledge;
import edu.cmu.tetrad.algcomparison.utils.UsesScoreWrapper;
import edu.cmu.tetrad.annotation.AlgType;
import edu.cmu.tetrad.annotation.Bootstrapping;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.Boss;
import edu.cmu.tetrad.search.PermutationSearch;
import edu.cmu.tetrad.search.score.Score;
import edu.cmu.tetrad.search.utils.LogUtilsSearch;
import edu.cmu.tetrad.search.utils.TsUtils;
import edu.cmu.tetrad.util.Parameters;
import edu.pitt.dbmi.algo.resampling.GeneralResamplingTest;
import java.util.ArrayList;
import java.util.List;

@edu.cmu.tetrad.annotation.Algorithm(name="BOSS-LiNGAM", command="boss-lingam", algoType=AlgType.forbid_latent_common_causes)
@Bootstrapping
public class BossLingam
implements Algorithm,
HasKnowledge,
UsesScoreWrapper,
ReturnsBootstrapGraphs {
    private static final long serialVersionUID = 23L;
    private ScoreWrapper score;
    private Knowledge knowledge = new Knowledge();
    private List<Graph> bootstrapGraphs = new ArrayList<Graph>();

    public BossLingam() {
    }

    public BossLingam(ScoreWrapper scoreWrapper) {
        this.score = scoreWrapper;
    }

    @Override
    public Graph search(DataModel dataModel, Parameters parameters) {
        if (parameters.getInt("numberResampling") < 1) {
            if (parameters.getInt("timeLag") > 0) {
                DataSet dataSet = (DataSet)dataModel;
                DataSet timeSeries = TsUtils.createLagData(dataSet, parameters.getInt("timeLag"));
                if (dataSet.getName() != null) {
                    timeSeries.setName(dataSet.getName());
                }
                dataModel = timeSeries;
                this.knowledge = timeSeries.getKnowledge();
            }
            Score score = this.score.getScore(dataModel, parameters);
            Boss boss = new Boss(score);
            boss.setUseBes(parameters.getBoolean("useBes"));
            boss.setNumStarts(parameters.getInt("numStarts"));
            boss.setNumThreads(parameters.getInt("numThreads"));
            boss.setUseDataOrder(parameters.getBoolean("useDataOrder"));
            boss.setVerbose(parameters.getBoolean("verbose"));
            PermutationSearch permutationSearch = new PermutationSearch(boss);
            permutationSearch.setKnowledge(this.knowledge);
            Graph cpdag = permutationSearch.search();
            edu.cmu.tetrad.search.BossLingam bossLingam = new edu.cmu.tetrad.search.BossLingam(cpdag, (DataSet)dataModel);
            Graph graph = bossLingam.search();
            LogUtilsSearch.stampWithBic(graph, dataModel);
            return graph;
        }
        BossLingam pcAll = new BossLingam(this.score);
        DataSet data = (DataSet)dataModel;
        GeneralResamplingTest search = new GeneralResamplingTest(data, pcAll, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        search.setKnowledge(this.knowledge);
        search.setParameters(parameters);
        search.setVerbose(parameters.getBoolean("verbose"));
        Graph graph = search.search();
        if (parameters.getBoolean("saveBootstrapGraphs")) {
            this.bootstrapGraphs = search.getGraphs();
        }
        return graph;
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        return new EdgeListGraph(graph);
    }

    @Override
    public String getDescription() {
        return "BOSS-LiNGAM using " + this.score.getDescription();
    }

    @Override
    public DataType getDataType() {
        return this.score.getDataType();
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("useBes");
        parameters.add("numStarts");
        parameters.add("timeLag");
        parameters.add("numThreads");
        parameters.add("useDataOrder");
        parameters.add("verbose");
        return parameters;
    }

    @Override
    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    @Override
    public ScoreWrapper getScoreWrapper() {
        return this.score;
    }

    @Override
    public void setScoreWrapper(ScoreWrapper score) {
        this.score = score;
    }

    @Override
    public List<Graph> getBootstrapGraphs() {
        return this.bootstrapGraphs;
    }
}

