/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.oracle.cpdag;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.algcomparison.algorithm.ReturnsBootstrapGraphs;
import edu.cmu.tetrad.algcomparison.independence.IndependenceWrapper;
import edu.cmu.tetrad.algcomparison.utils.HasKnowledge;
import edu.cmu.tetrad.algcomparison.utils.TakesIndependenceWrapper;
import edu.cmu.tetrad.annotation.AlgType;
import edu.cmu.tetrad.annotation.Bootstrapping;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphTransforms;
import edu.cmu.tetrad.search.utils.LogUtilsSearch;
import edu.cmu.tetrad.search.utils.PcCommon;
import edu.cmu.tetrad.search.utils.TsUtils;
import edu.cmu.tetrad.util.Parameters;
import edu.pitt.dbmi.algo.resampling.GeneralResamplingTest;
import java.util.ArrayList;
import java.util.List;

@edu.cmu.tetrad.annotation.Algorithm(name="CPC", command="cpc", algoType=AlgType.forbid_latent_common_causes)
@Bootstrapping
public class Cpc
implements Algorithm,
HasKnowledge,
TakesIndependenceWrapper,
ReturnsBootstrapGraphs {
    private static final long serialVersionUID = 23L;
    private IndependenceWrapper test;
    private Knowledge knowledge = new Knowledge();
    private List<Graph> bootstrapGraphs = new ArrayList<Graph>();

    public Cpc() {
    }

    public Cpc(IndependenceWrapper test) {
        this.test = test;
    }

    @Override
    public Graph search(DataModel dataModel, Parameters parameters) {
        if (parameters.getInt("numberResampling") < 1) {
            PcCommon.ConflictRule conflictRule;
            if (parameters.getInt("timeLag") > 0) {
                DataSet dataSet = (DataSet)dataModel;
                DataSet timeSeries = TsUtils.createLagData(dataSet, parameters.getInt("timeLag"));
                if (dataSet.getName() != null) {
                    timeSeries.setName(dataSet.getName());
                }
                dataModel = timeSeries;
                this.knowledge = timeSeries.getKnowledge();
            }
            switch (parameters.getInt("conflictRule")) {
                case 1: {
                    conflictRule = PcCommon.ConflictRule.PRIORITIZE_EXISTING;
                    break;
                }
                case 2: {
                    conflictRule = PcCommon.ConflictRule.ORIENT_BIDIRECTED;
                    break;
                }
                case 3: {
                    conflictRule = PcCommon.ConflictRule.OVERWRITE_EXISTING;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown conflict rule: " + parameters.getInt("conflictRule"));
                }
            }
            edu.cmu.tetrad.search.Cpc search = new edu.cmu.tetrad.search.Cpc(this.getIndependenceWrapper().getTest(dataModel, parameters));
            search.setDepth(parameters.getInt("depth"));
            search.meekPreventCycles(parameters.getBoolean("meekPreventCycles"));
            search.setVerbose(parameters.getBoolean("verbose"));
            search.setKnowledge(this.knowledge);
            search.setConflictRule(conflictRule);
            Graph graph = search.search();
            LogUtilsSearch.stampWithBic(graph, dataModel);
            return graph;
        }
        Cpc pcAll = new Cpc(this.test);
        DataSet data = (DataSet)dataModel;
        GeneralResamplingTest search = new GeneralResamplingTest(data, pcAll, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        search.setKnowledge(this.knowledge);
        search.setParameters(parameters);
        search.setVerbose(parameters.getBoolean("verbose"));
        Graph graph = search.search();
        if (parameters.getBoolean("saveBootstrapGraphs")) {
            this.bootstrapGraphs = search.getGraphs();
        }
        return graph;
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        EdgeListGraph dag = new EdgeListGraph(graph);
        return GraphTransforms.cpdagForDag(dag);
    }

    @Override
    public String getDescription() {
        return "CPC using " + this.test.getDescription();
    }

    @Override
    public DataType getDataType() {
        return this.test.getDataType();
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("stableFAS");
        parameters.add("conflictRule");
        parameters.add("meekPreventCycles");
        parameters.add("depth");
        parameters.add("timeLag");
        parameters.add("verbose");
        return parameters;
    }

    @Override
    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    @Override
    public IndependenceWrapper getIndependenceWrapper() {
        return this.test;
    }

    @Override
    public void setIndependenceWrapper(IndependenceWrapper test) {
        this.test = test;
    }

    @Override
    public List<Graph> getBootstrapGraphs() {
        return this.bootstrapGraphs;
    }
}

