/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.oracle.cpdag;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.algcomparison.algorithm.ReturnsBootstrapGraphs;
import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.algcomparison.score.SemBicScoreDeterministic;
import edu.cmu.tetrad.annotation.Bootstrapping;
import edu.cmu.tetrad.annotation.Experimental;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphTransforms;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.FactorAnalysis;
import edu.cmu.tetrad.search.Fges;
import edu.cmu.tetrad.search.score.Score;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetrad.util.TextTable;
import edu.pitt.dbmi.algo.resampling.GeneralResamplingTest;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.util.FastMath;

@Bootstrapping
@Experimental
public class GesMe
implements Algorithm,
ReturnsBootstrapGraphs {
    private static final long serialVersionUID = 23L;
    private final ScoreWrapper score = new SemBicScoreDeterministic();
    private boolean compareToTrue;
    private List<Graph> bootstrapGraphs = new ArrayList<Graph>();

    public GesMe() {
        this.setCompareToTrue(false);
    }

    public GesMe(boolean compareToTrueGraph) {
        this.setCompareToTrue(compareToTrueGraph);
    }

    @Override
    public Graph search(DataModel dataSet, Parameters parameters) {
        if (parameters.getInt("numberResampling") < 1) {
            CovarianceMatrix covarianceMatrix = new CovarianceMatrix((DataSet)dataSet);
            FactorAnalysis analysis = new FactorAnalysis(covarianceMatrix);
            analysis.setThreshold(parameters.getDouble("convergenceThreshold"));
            analysis.setNumFactors(parameters.getInt("numFactors"));
            Matrix unrotated = analysis.successiveResidual();
            Matrix rotated = analysis.successiveFactorVarimax(unrotated);
            if (parameters.getBoolean("verbose")) {
                NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
                String output = "Unrotated Factor Loading Matrix:\n";
                output = output + this.tableString(unrotated, nf, Double.POSITIVE_INFINITY);
                if (unrotated.getNumColumns() != 1) {
                    output = output + "\n\nRotated Matrix (using sequential varimax):\n";
                    output = output + this.tableString(rotated, nf, parameters.getDouble("fa_threshold"));
                }
                System.out.println(output);
                TetradLogger.getInstance().forceLogMessage(output);
            }
            Matrix L = parameters.getBoolean("useVarimax") ? rotated : unrotated;
            Matrix residual = analysis.getResidual();
            CovarianceMatrix covFa = new CovarianceMatrix(covarianceMatrix.getVariables(), L.times(L.transpose()), covarianceMatrix.getSampleSize());
            System.out.println(covFa);
            double[] vars = covarianceMatrix.getMatrix().diag().toArray();
            ArrayList<Integer> indices = new ArrayList<Integer>();
            for (int i = 0; i < vars.length; ++i) {
                indices.add(i);
            }
            indices.sort((o1, o2) -> -Double.compare(vars[o1], vars[o2]));
            DecimalFormat nf = new DecimalFormat("0.000");
            for (Integer index : indices) {
                System.out.println(nf.format(vars[index]) + " ");
            }
            System.out.println();
            int n = vars.length;
            int cutoff = (int)((double)n * ((FastMath.sqrt(8 * n + 1) - 1.0) / (double)(2 * n)));
            List<Node> nodes = covarianceMatrix.getVariables();
            ArrayList<Node> leaves = new ArrayList<Node>();
            for (int i = 0; i < cutoff; ++i) {
                leaves.add(nodes.get((Integer)indices.get(i)));
            }
            Knowledge knowledge2 = new Knowledge();
            for (Node v : nodes) {
                if (leaves.contains(v)) {
                    knowledge2.addToTier(2, v.getName());
                    continue;
                }
                knowledge2.addToTier(1, v.getName());
            }
            knowledge2.setTierForbiddenWithin(2, true);
            System.out.println("knowledge2 = " + knowledge2);
            Score score = this.score.getScore(covFa, parameters);
            Fges search = new Fges(score);
            search.setFaithfulnessAssumed(parameters.getBoolean("faithfulnessAssumed"));
            if (parameters.getBoolean("enforceMinimumLeafNodes")) {
                search.setKnowledge(knowledge2);
            }
            search.setVerbose(parameters.getBoolean("verbose"));
            search.setMaxDegree(parameters.getInt("maxDegree"));
            search.setSymmetricFirstStep(parameters.getBoolean("symmetricFirstStep"));
            Object obj = parameters.get("printStream");
            if (obj instanceof PrintStream) {
                search.setOut((PrintStream)obj);
            }
            if (parameters.getBoolean("verbose")) {
                String output = "Unrotated Factor Loading Matrix:\n";
                double threshold = parameters.getDouble("fa_threshold");
                output = output + this.tableString(L, nf, Double.POSITIVE_INFINITY);
                if (L.getNumColumns() != 1) {
                    output = output + "\n\nL:\n";
                    output = output + this.tableString(L, nf, threshold);
                }
                System.out.println(output);
                TetradLogger.getInstance().forceLogMessage(output);
            }
            System.out.println("residual = " + residual);
            return search.search();
        }
        GesMe algorithm = new GesMe(this.compareToTrue);
        DataSet data = (DataSet)dataSet;
        GeneralResamplingTest search = new GeneralResamplingTest(data, algorithm, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        search.setParameters(parameters);
        search.setVerbose(parameters.getBoolean("verbose"));
        Graph graph = search.search();
        if (parameters.getBoolean("saveBootstrapGraphs")) {
            this.bootstrapGraphs = search.getGraphs();
        }
        return graph;
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        if (this.compareToTrue) {
            return new EdgeListGraph(graph);
        }
        EdgeListGraph dag = new EdgeListGraph(graph);
        return GraphTransforms.cpdagForDag(dag);
    }

    @Override
    public String getDescription() {
        return "FGES (Fast Greedy Equivalence Search) using " + this.score.getDescription();
    }

    @Override
    public DataType getDataType() {
        return this.score.getDataType();
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("symmetricFirstStep");
        parameters.add("faithfulnessAssumed");
        parameters.add("maxDegree");
        parameters.add("determinismThreshold");
        parameters.add("convergenceThreshold");
        parameters.add("fa_threshold");
        parameters.add("numFactors");
        parameters.add("useVarimax");
        parameters.add("enforceMinimumLeafNodes");
        parameters.add("verbose");
        return parameters;
    }

    public void setCompareToTrue(boolean compareToTrue) {
        this.compareToTrue = compareToTrue;
    }

    private String tableString(Matrix matrix, NumberFormat nf, double threshold) {
        TextTable table = new TextTable(matrix.getNumRows() + 1, matrix.getNumColumns() + 1);
        for (int i = 0; i < matrix.getNumRows() + 1; ++i) {
            for (int j = 0; j < matrix.getNumColumns() + 1; ++j) {
                if (i > 0 && j == 0) {
                    table.setToken(i, 0, "X" + i);
                    continue;
                }
                if (i == 0 && j > 0) {
                    table.setToken(0, j, "Factor " + j);
                    continue;
                }
                if (i <= 0) continue;
                double coefficient = matrix.get(i - 1, j - 1);
                String token = !Double.isNaN(coefficient) ? nf.format(coefficient) : "Undefined";
                token = token + (FastMath.abs(coefficient) > threshold ? "*" : " ");
                table.setToken(i, j, token);
            }
        }
        return "\n" + table;
    }

    @Override
    public List<Graph> getBootstrapGraphs() {
        return this.bootstrapGraphs;
    }
}

