/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.oracle.cpdag;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.algcomparison.algorithm.ReturnsBootstrapGraphs;
import edu.cmu.tetrad.algcomparison.independence.IndependenceWrapper;
import edu.cmu.tetrad.algcomparison.utils.HasKnowledge;
import edu.cmu.tetrad.algcomparison.utils.TakesIndependenceWrapper;
import edu.cmu.tetrad.annotation.AlgType;
import edu.cmu.tetrad.annotation.Bootstrapping;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.util.Parameters;
import edu.pitt.dbmi.algo.resampling.GeneralResamplingTest;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@edu.cmu.tetrad.annotation.Algorithm(name="PC-MB", command="pc-mb", algoType=AlgType.search_for_Markov_blankets)
@Bootstrapping
public class PcMb
implements Algorithm,
HasKnowledge,
TakesIndependenceWrapper,
ReturnsBootstrapGraphs {
    private static final long serialVersionUID = 23L;
    private IndependenceWrapper test;
    private Knowledge knowledge = new Knowledge();
    private List<Node> targets;
    private List<Graph> bootstrapGraphs = new ArrayList<Graph>();

    public PcMb() {
    }

    public PcMb(IndependenceWrapper type) {
        this.test = type;
    }

    @Override
    public Graph search(DataModel dataSet, Parameters parameters) {
        if (parameters.getInt("numberResampling") < 1) {
            IndependenceTest test = this.test.getTest(dataSet, parameters);
            edu.cmu.tetrad.search.PcMb search = new edu.cmu.tetrad.search.PcMb(test, parameters.getInt("depth"));
            List<Node> targets = this.targets(test, parameters.getString("targets"));
            this.targets = targets;
            search.setDepth(parameters.getInt("depth"));
            search.setKnowledge(this.knowledge);
            search.setFindMb(parameters.getBoolean("mb"));
            return search.search(targets);
        }
        PcMb algorithm = new PcMb(this.test);
        DataSet data = (DataSet)dataSet;
        GeneralResamplingTest search = new GeneralResamplingTest(data, algorithm, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        search.setKnowledge(this.knowledge);
        search.setParameters(parameters);
        search.setVerbose(parameters.getBoolean("verbose"));
        Graph graph = search.search();
        if (parameters.getBoolean("saveBootstrapGraphs")) {
            this.bootstrapGraphs = search.getGraphs();
        }
        return graph;
    }

    @NotNull
    private List<Node> targets(IndependenceTest test, String targetString) {
        String[] _targets = targetString.contains(",") ? targetString.split(",") : targetString.split(" ");
        ArrayList<Node> targets = new ArrayList<Node>();
        for (String _target : _targets) {
            targets.add(test.getVariable(_target));
        }
        return targets;
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        return GraphUtils.markovBlanketSubgraph(this.targets.get(0), new EdgeListGraph(graph));
    }

    @Override
    public String getDescription() {
        return "PC-MB (Markov blanket search using PC) using " + this.test.getDescription();
    }

    @Override
    public DataType getDataType() {
        return this.test.getDataType();
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("targets");
        parameters.add("mb");
        parameters.add("depth");
        parameters.add("verbose");
        return parameters;
    }

    @Override
    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    @Override
    public IndependenceWrapper getIndependenceWrapper() {
        return this.test;
    }

    @Override
    public void setIndependenceWrapper(IndependenceWrapper test) {
        this.test = test;
    }

    @Override
    public List<Graph> getBootstrapGraphs() {
        return this.bootstrapGraphs;
    }
}

