/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.oracle.cpdag;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.algcomparison.algorithm.ReturnsBootstrapGraphs;
import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.algcomparison.utils.UsesScoreWrapper;
import edu.cmu.tetrad.annotation.AlgType;
import edu.cmu.tetrad.annotation.Bootstrapping;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Boss;
import edu.cmu.tetrad.search.PermutationSearch;
import edu.cmu.tetrad.search.score.Score;
import edu.cmu.tetrad.util.Parameters;
import edu.pitt.dbmi.algo.resampling.GeneralResamplingTest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

@edu.cmu.tetrad.annotation.Algorithm(name="Restricted-BOSS", command="r-boss", algoType=AlgType.forbid_latent_common_causes)
@Bootstrapping
public class RestrictedBoss
implements Algorithm,
UsesScoreWrapper,
ReturnsBootstrapGraphs {
    private static final long serialVersionUID = 23L;
    private ScoreWrapper score;
    private List<Graph> bootstrapGraphs = new ArrayList<Graph>();

    public RestrictedBoss() {
    }

    public RestrictedBoss(ScoreWrapper score) {
        this.score = score;
    }

    @Override
    public Graph search(DataModel dataModel, Parameters parameters) {
        if (parameters.getInt("numberResampling") < 1) {
            DataSet dataSet = (DataSet)dataModel;
            String string = parameters.getString("targets");
            String[] _targets = string.contains(",") ? string.split(",") : string.split(" ");
            ArrayList<Node> targets = new ArrayList<Node>();
            for (String _target : _targets) {
                targets.add(dataSet.getVariable(_target));
            }
            for (Node node : targets) {
                if (node != null) continue;
                throw new IllegalArgumentException("Targets need to be specified correctly.");
            }
            System.out.println("targets: " + targets);
            Knowledge knowledge = new Knowledge();
            for (Node node : targets) {
                knowledge.addToTier(2, node.getName());
            }
            for (Node node : dataSet.getVariables()) {
                if (targets.contains(node)) continue;
                knowledge.addToTier(1, node.getName());
            }
            knowledge.setTierForbiddenWithin(1, true);
            Score score = this.score.getScore(dataSet, parameters);
            Boss boss = new Boss(score);
            boss.setUseBes(parameters.getBoolean("useBes"));
            boss.setNumStarts(parameters.getInt("numStarts"));
            PermutationSearch permutationSearch = new PermutationSearch(boss);
            permutationSearch.setKnowledge(knowledge);
            permutationSearch.search();
            HashSet<Node> restrictedSet = new HashSet<Node>(targets);
            for (Node node : targets) {
                restrictedSet.addAll(permutationSearch.getGST(node).getFirstLayer());
            }
            ArrayList<Node> restrictedList = new ArrayList<Node>(restrictedSet);
            Collections.sort(restrictedList);
            DataSet restrictedData = dataSet.subsetColumns(restrictedList);
            System.out.println("Restricted data # vars: " + restrictedData.getVariables().size());
            knowledge = new Knowledge();
            for (Node node : targets) {
                knowledge.addToTier(2, node.getName());
            }
            for (Node node : restrictedData.getVariables()) {
                if (targets.contains(node)) continue;
                knowledge.addToTier(1, node.getName());
            }
            knowledge.setTierForbiddenWithin(1, false);
            score = this.score.getScore(restrictedData, parameters);
            boss = new Boss(score);
            boss.setUseBes(parameters.getBoolean("useBes"));
            boss.setNumStarts(parameters.getInt("numStarts"));
            permutationSearch = new PermutationSearch(boss);
            permutationSearch.setKnowledge(knowledge);
            Graph graph = permutationSearch.search();
            graph = GraphUtils.trimGraph(targets, graph, parameters.getInt("trimmingStyle"));
            return graph;
        }
        RestrictedBoss algorithm = new RestrictedBoss(this.score);
        DataSet data = (DataSet)dataModel;
        GeneralResamplingTest search = new GeneralResamplingTest(data, algorithm, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        search.setParameters(parameters);
        Graph graph = search.search();
        if (parameters.getBoolean("saveBootstrapGraphs")) {
            this.bootstrapGraphs = search.getGraphs();
        }
        return graph;
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        return new EdgeListGraph(graph);
    }

    @Override
    public String getDescription() {
        return "Restricted BOSS (Best Order Score Search) using " + this.score.getDescription();
    }

    @Override
    public DataType getDataType() {
        return this.score.getDataType();
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("useBes");
        params.add("numStarts");
        params.add("targets");
        params.add("trimmingStyle");
        return params;
    }

    @Override
    public ScoreWrapper getScoreWrapper() {
        return this.score;
    }

    @Override
    public void setScoreWrapper(ScoreWrapper score) {
        this.score = score;
    }

    @Override
    public List<Graph> getBootstrapGraphs() {
        return this.bootstrapGraphs;
    }
}

