/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.oracle.pag;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.algcomparison.independence.IndependenceWrapper;
import edu.cmu.tetrad.algcomparison.independence.ProbabilisticTest;
import edu.cmu.tetrad.algcomparison.utils.HasKnowledge;
import edu.cmu.tetrad.annotation.AlgType;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphTransforms;
import edu.cmu.tetrad.util.Parameters;
import edu.pitt.dbmi.algo.bayesian.constraint.search.PagSamplingRfci;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

@edu.cmu.tetrad.annotation.Algorithm(name="PAG-Sampling-RFCI", command="pag-sampling-rfci", algoType=AlgType.allow_latent_common_causes)
public class PagSampleRfci
implements Algorithm,
HasKnowledge {
    public static final List<String> PAG_SAMPLING_RFCI_PARAMETERS = new LinkedList<String>();
    public static final List<String> RFCI_PARAMETERS = new LinkedList<String>();
    public static final List<String> PROBABILISTIC_TEST_PARAMETERS = new LinkedList<String>();
    private static final long serialVersionUID = 23L;
    private final IndependenceWrapper test = new ProbabilisticTest();
    private Knowledge knowledge;
    private List<Graph> bootstrapGraphs = new ArrayList<Graph>();

    @Override
    public Graph search(DataModel dataSet, Parameters parameters) {
        PagSamplingRfci pagSamplingRfci = new PagSamplingRfci(SimpleDataLoader.getDiscreteDataSet(dataSet));
        pagSamplingRfci.setNumRandomizedSearchModels(parameters.getInt("numRandomizedSearchModels"));
        pagSamplingRfci.setVerbose(parameters.getBoolean("verbose"));
        pagSamplingRfci.setKnowledge(this.knowledge);
        pagSamplingRfci.setDepth(parameters.getInt("depth"));
        pagSamplingRfci.setMaxPathLength(parameters.getInt("maxPathLength"));
        pagSamplingRfci.setThreshold(parameters.getBoolean("noRandomlyDeterminedIndependence"));
        pagSamplingRfci.setCutoff(parameters.getDouble("cutoffIndTest"));
        pagSamplingRfci.setPriorEquivalentSampleSize(parameters.getDouble("priorEquivalentSampleSize"));
        return pagSamplingRfci.search();
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        EdgeListGraph trueGraph = new EdgeListGraph(graph);
        return GraphTransforms.dagToPag(trueGraph);
    }

    @Override
    public String getDescription() {
        return "PAG-Sampling-RFCI " + this.test.getDescription();
    }

    @Override
    public DataType getDataType() {
        return DataType.Discrete;
    }

    @Override
    public List<String> getParameters() {
        LinkedList<String> parameters = new LinkedList<String>();
        parameters.addAll(PAG_SAMPLING_RFCI_PARAMETERS);
        parameters.addAll(RFCI_PARAMETERS);
        parameters.addAll(PROBABILISTIC_TEST_PARAMETERS);
        return parameters;
    }

    @Override
    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = knowledge;
    }

    static {
        PAG_SAMPLING_RFCI_PARAMETERS.add("numRandomizedSearchModels");
        PAG_SAMPLING_RFCI_PARAMETERS.add("verbose");
        RFCI_PARAMETERS.add("depth");
        RFCI_PARAMETERS.add("maxPathLength");
        PROBABILISTIC_TEST_PARAMETERS.add("noRandomlyDeterminedIndependence");
        PROBABILISTIC_TEST_PARAMETERS.add("cutoffIndTest");
        PROBABILISTIC_TEST_PARAMETERS.add("priorEquivalentSampleSize");
    }
}

