/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.oracle.pag;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.algcomparison.independence.IndependenceWrapper;
import edu.cmu.tetrad.algcomparison.independence.ProbabilisticTest;
import edu.cmu.tetrad.algcomparison.utils.HasKnowledge;
import edu.cmu.tetrad.annotation.AlgType;
import edu.cmu.tetrad.annotation.Experimental;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphTransforms;
import edu.cmu.tetrad.search.Rfci;
import edu.cmu.tetrad.util.Parameters;
import java.util.ArrayList;
import java.util.List;

@edu.cmu.tetrad.annotation.Algorithm(name="RFCI-BSC", command="rfci-bsc", algoType=AlgType.forbid_latent_common_causes, dataType={DataType.Discrete})
@Experimental
public class RfciBsc
implements Algorithm,
HasKnowledge {
    private static final long serialVersionUID = 23L;
    private final IndependenceWrapper test = new ProbabilisticTest();
    private Knowledge knowledge = new Knowledge();
    private List<Graph> bootstrapGraphs = new ArrayList<Graph>();

    @Override
    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    @Override
    public Graph search(DataModel dataSet, Parameters parameters) {
        Rfci search = new Rfci(this.test.getTest(dataSet, parameters));
        search.setKnowledge(this.knowledge);
        search.setDepth(parameters.getInt("depth"));
        search.setMaxPathLength(parameters.getInt("maxPathLength"));
        search.setVerbose(parameters.getBoolean("verbose"));
        edu.pitt.dbmi.algo.bayesian.constraint.search.RfciBsc RfciBsc2 = new edu.pitt.dbmi.algo.bayesian.constraint.search.RfciBsc(search);
        RfciBsc2.setNumRandomizedSearchModels(parameters.getInt("numRandomizedSearchModels"));
        RfciBsc2.setThresholdNoRandomDataSearch(parameters.getBoolean("thresholdNoRandomDataSearch"));
        RfciBsc2.setCutoffDataSearch(parameters.getDouble("cutoffDataSearch"));
        RfciBsc2.setNumBscBootstrapSamples(parameters.getInt("numBscBootstrapSamples"));
        RfciBsc2.setThresholdNoRandomConstrainSearch(parameters.getBoolean("thresholdNoRandomConstrainSearch"));
        RfciBsc2.setCutoffConstrainSearch(parameters.getDouble("cutoffConstrainSearch"));
        RfciBsc2.setLowerBound(parameters.getDouble("lowerBound"));
        RfciBsc2.setUpperBound(parameters.getDouble("upperBound"));
        RfciBsc2.setOutputRBD(parameters.getBoolean("outputRBD"));
        RfciBsc2.setVerbose(parameters.getBoolean("verbose"));
        return RfciBsc2.search();
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        EdgeListGraph trueGraph = new EdgeListGraph(graph);
        return GraphTransforms.dagToPag(trueGraph);
    }

    @Override
    public String getDescription() {
        return "RFCI-BSC using " + this.test.getDescription();
    }

    @Override
    public DataType getDataType() {
        return DataType.Discrete;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("depth");
        parameters.add("maxPathLength");
        parameters.add("completeRuleSetUsed");
        parameters.add("numRandomizedSearchModels");
        parameters.add("thresholdNoRandomDataSearch");
        parameters.add("cutoffDataSearch");
        parameters.add("numBscBootstrapSamples");
        parameters.add("thresholdNoRandomConstrainSearch");
        parameters.add("cutoffConstrainSearch");
        parameters.add("lowerBound");
        parameters.add("upperBound");
        parameters.add("outputRBD");
        parameters.add("verbose");
        return parameters;
    }
}

