/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.oracle.pattern;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.algcomparison.independence.IndependenceWrapper;
import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.algcomparison.utils.TakesIndependenceWrapper;
import edu.cmu.tetrad.algcomparison.utils.UsesScoreWrapper;
import edu.cmu.tetrad.annotation.AlgType;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Cstar;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

@edu.cmu.tetrad.annotation.Algorithm(name="CStaR", command="cstar", algoType=AlgType.forbid_latent_common_causes)
public class Cstar
implements Algorithm,
UsesScoreWrapper,
TakesIndependenceWrapper {
    private static final long serialVersionUID = 23L;
    private IndependenceWrapper test;
    private ScoreWrapper score;
    private LinkedList<Cstar.Record> records;

    public Cstar() {
    }

    public Cstar(IndependenceWrapper test, ScoreWrapper score) {
        this.test = test;
        this.score = score;
    }

    @Override
    public Graph search(DataModel dataSet, Parameters parameters) {
        Cstar.SampleStyle sampleStyle;
        Cstar.CpdagAlgorithm algorithm;
        System.out.println("# Available Processors = " + Runtime.getRuntime().availableProcessors());
        System.out.println("Parallelized = " + parameters.getBoolean("parallelized"));
        edu.cmu.tetrad.search.Cstar cStaR = new edu.cmu.tetrad.search.Cstar(this.test, this.score, parameters);
        switch (parameters.getInt("cstarCpdagAlgorithm")) {
            case 1: {
                algorithm = Cstar.CpdagAlgorithm.PC_STABLE;
                break;
            }
            case 2: {
                algorithm = Cstar.CpdagAlgorithm.FGES;
                break;
            }
            case 3: {
                algorithm = Cstar.CpdagAlgorithm.BOSS;
                break;
            }
            case 4: {
                algorithm = Cstar.CpdagAlgorithm.RESTRICTED_BOSS;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown CPDAG algorithm: " + parameters.getInt("cstarCpdagAlgorithm"));
            }
        }
        switch (parameters.getInt("sampleStyle")) {
            case 1: {
                sampleStyle = Cstar.SampleStyle.SUBSAMPLE;
                break;
            }
            case 2: {
                sampleStyle = Cstar.SampleStyle.BOOTSTRAP;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown sample style: " + parameters.getInt("sampleStyle"));
            }
        }
        int topBracket = parameters.getInt("topBracket");
        cStaR.setParallelized(parameters.getBoolean("parallelized"));
        cStaR.setNumSubsamples(parameters.getInt("numSubsamples"));
        cStaR.setSelectionAlpha(parameters.getDouble("selectionMinEffect"));
        cStaR.setCpdagAlgorithm(algorithm);
        cStaR.setSampleStyle(sampleStyle);
        cStaR.setVerbose(parameters.getBoolean("verbose"));
        ArrayList<Node> possibleEffects = new ArrayList<Node>();
        String targetNames = parameters.getString("targets");
        if (targetNames.trim().equalsIgnoreCase("")) {
            throw new IllegalStateException("Please specify target name(s).");
        }
        if (targetNames.trim().equalsIgnoreCase("all")) {
            for (String name : dataSet.getVariableNames()) {
                possibleEffects.add(dataSet.getVariable(name));
            }
        } else {
            String string = parameters.getString("targets");
            String[] _targets = string.contains(",") ? string.split(",") : string.split(" ");
            for (String _target : _targets) {
                possibleEffects.add(dataSet.getVariable(_target));
            }
        }
        ArrayList<Node> possibleCauses = new ArrayList<Node>(dataSet.getVariables());
        if (parameters.getBoolean("removeEffectNodes")) {
            possibleCauses.removeAll(possibleEffects);
        }
        if (!(dataSet instanceof DataSet)) {
            throw new IllegalArgumentException("Expecting tabular data for CStaR.");
        }
        String path = parameters.getString("fileOutPath");
        LinkedList<LinkedList<Cstar.Record>> allRecords = cStaR.getRecords((DataSet)dataSet, possibleCauses, possibleEffects, topBracket, path);
        if (allRecords.isEmpty()) {
            throw new IllegalStateException("There were no records.");
        }
        this.records = allRecords.getLast();
        TetradLogger.getInstance().forceLogMessage("CStaR Table");
        String table1 = cStaR.makeTable(edu.cmu.tetrad.search.Cstar.cStar(allRecords));
        TetradLogger.getInstance().forceLogMessage(table1);
        File _file = new File(cStaR.getDir(), "/cstar_table.txt");
        try {
            PrintWriter writer = new PrintWriter(_file);
            writer.println(table1);
            writer.close();
        }
        catch (IOException e) {
            System.out.println("Error writing to file: " + _file.getAbsolutePath());
        }
        TetradLogger.getInstance().forceLogMessage("Files stored in : " + cStaR.getDir().getAbsolutePath());
        return cStaR.makeGraph(this.getRecords());
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        return new EdgeListGraph();
    }

    @Override
    public String getDescription() {
        return "CStaR";
    }

    @Override
    public DataType getDataType() {
        return DataType.Mixed;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("selectionMinEffect");
        parameters.add("numSubsamples");
        parameters.add("targets");
        parameters.add("topBracket");
        parameters.add("parallelized");
        parameters.add("cstarCpdagAlgorithm");
        parameters.add("fileOutPath");
        parameters.add("removeEffectNodes");
        parameters.add("sampleStyle");
        parameters.add("verbose");
        return parameters;
    }

    @Override
    public ScoreWrapper getScoreWrapper() {
        return this.score;
    }

    @Override
    public void setScoreWrapper(ScoreWrapper score) {
        this.score = score;
    }

    public LinkedList<Cstar.Record> getRecords() {
        return this.records;
    }

    @Override
    public IndependenceWrapper getIndependenceWrapper() {
        return this.test;
    }

    @Override
    public void setIndependenceWrapper(IndependenceWrapper independenceWrapper) {
        this.test = independenceWrapper;
    }
}

