/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.other;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.annotation.Bootstrapping;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetrad.util.TextTable;
import edu.pitt.dbmi.algo.resampling.GeneralResamplingTest;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.commons.math3.util.FastMath;

@Bootstrapping
public class FactorAnalysis
implements Algorithm {
    private static final long serialVersionUID = 23L;

    @Override
    public Graph search(DataModel ds, Parameters parameters) {
        if (parameters.getInt("numberResampling") < 1) {
            int i;
            DataSet selectedModel = (DataSet)ds;
            if (selectedModel == null) {
                throw new NullPointerException("Data not specified.");
            }
            edu.cmu.tetrad.search.FactorAnalysis analysis = new edu.cmu.tetrad.search.FactorAnalysis(selectedModel);
            analysis.setThreshold(parameters.getDouble("convergenceThreshold"));
            analysis.setNumFactors(parameters.getInt("numFactors"));
            double threshold = parameters.getDouble("fa_threshold");
            Matrix unrotatedSolution = analysis.successiveResidual();
            Matrix rotatedSolution = analysis.successiveFactorVarimax(unrotatedSolution);
            SemGraph graph = new SemGraph();
            Vector<Node> observedVariables = new Vector<Node>();
            for (Node a : selectedModel.getVariables()) {
                graph.addNode(a);
                observedVariables.add(a);
            }
            Vector<ContinuousVariable> factors = new Vector<ContinuousVariable>();
            if (parameters.getBoolean("useVarimax")) {
                for (i = 0; i < rotatedSolution.getNumColumns(); ++i) {
                    ContinuousVariable factor = new ContinuousVariable("Factor" + (i + 1));
                    factor.setNodeType(NodeType.LATENT);
                    graph.addNode(factor);
                    factors.add(factor);
                }
                for (i = 0; i < rotatedSolution.getNumRows(); ++i) {
                    for (int j = 0; j < rotatedSolution.getNumColumns(); ++j) {
                        if (!(FastMath.abs(rotatedSolution.get(i, j)) > threshold)) continue;
                        graph.addDirectedEdge((Node)factors.get(j), (Node)observedVariables.get(i));
                    }
                }
            } else {
                for (i = 0; i < unrotatedSolution.getNumColumns(); ++i) {
                    ContinuousVariable factor = new ContinuousVariable("Factor" + (i + 1));
                    factor.setNodeType(NodeType.LATENT);
                    graph.addNode(factor);
                    factors.add(factor);
                }
                for (i = 0; i < unrotatedSolution.getNumRows(); ++i) {
                    for (int j = 0; j < unrotatedSolution.getNumColumns(); ++j) {
                        if (!(FastMath.abs(unrotatedSolution.get(i, j)) > threshold)) continue;
                        graph.addDirectedEdge((Node)factors.get(j), (Node)observedVariables.get(i));
                    }
                }
            }
            if (parameters.getBoolean("verbose")) {
                NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
                String output = "Unrotated Factor Loading Matrix:\n";
                output = output + this.tableString(unrotatedSolution, nf, Double.POSITIVE_INFINITY);
                if (unrotatedSolution.getNumColumns() != 1) {
                    output = output + "\n\nRotated Matrix (using sequential varimax):\n";
                    output = output + this.tableString(rotatedSolution, nf, threshold);
                }
                System.out.println(output);
                TetradLogger.getInstance().forceLogMessage(output);
            }
            return graph;
        }
        FactorAnalysis algorithm = new FactorAnalysis();
        DataSet data = (DataSet)ds;
        GeneralResamplingTest search = new GeneralResamplingTest(data, algorithm, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        search.setParameters(parameters);
        search.setVerbose(parameters.getBoolean("verbose"));
        return search.search();
    }

    private String tableString(Matrix matrix, NumberFormat nf, double threshold) {
        TextTable table = new TextTable(matrix.getNumRows() + 1, matrix.getNumColumns() + 1);
        for (int i = 0; i < matrix.getNumRows() + 1; ++i) {
            for (int j = 0; j < matrix.getNumColumns() + 1; ++j) {
                if (i > 0 && j == 0) {
                    table.setToken(i, 0, "X" + i);
                    continue;
                }
                if (i == 0 && j > 0) {
                    table.setToken(0, j, "Factor " + j);
                    continue;
                }
                if (i <= 0) continue;
                double coefficient = matrix.get(i - 1, j - 1);
                String token = !Double.isNaN(coefficient) ? nf.format(coefficient) : "Undefined";
                token = token + (FastMath.abs(coefficient) > threshold ? "*" : " ");
                table.setToken(i, j, token);
            }
        }
        return "\n" + table;
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        return GraphUtils.undirectedGraph(graph);
    }

    @Override
    public String getDescription() {
        return "GLASSO (Graphical LASSO)";
    }

    @Override
    public DataType getDataType() {
        return DataType.Mixed;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("fa_threshold");
        params.add("numFactors");
        params.add("useVarimax");
        params.add("convergenceThreshold");
        params.add("verbose");
        return params;
    }
}

