/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.other;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.annotation.AlgType;
import edu.cmu.tetrad.annotation.Bootstrapping;
import edu.cmu.tetrad.annotation.Experimental;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.work_in_progress.Glasso;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.Parameters;
import edu.pitt.dbmi.algo.resampling.GeneralResamplingTest;
import java.util.ArrayList;
import java.util.List;

@edu.cmu.tetrad.annotation.Algorithm(name="GLASSO", command="glasso", algoType=AlgType.produce_undirected_graphs, dataType={DataType.Continuous})
@Bootstrapping
@Experimental
public class Glasso
implements Algorithm {
    private static final long serialVersionUID = 23L;

    @Override
    public Graph search(DataModel ds, Parameters parameters) {
        DataSet _data = (DataSet)ds;
        for (int j = 0; j < _data.getNumColumns(); ++j) {
            for (int i = 0; i < _data.getNumRows(); ++i) {
                if (!Double.isNaN(_data.getDouble(i, j))) continue;
                throw new IllegalArgumentException("Please remove or impute missing values.");
            }
        }
        if (parameters.getInt("numberResampling") < 1) {
            Matrix cov = new Matrix(SimpleDataLoader.getContinuousDataSet(ds).getCovarianceMatrix().toArray());
            edu.cmu.tetrad.search.work_in_progress.Glasso glasso = new edu.cmu.tetrad.search.work_in_progress.Glasso(cov);
            glasso.setMaxit(parameters.getInt("maxit"));
            glasso.setIa(parameters.getBoolean("ia"));
            glasso.setIs(parameters.getBoolean("is"));
            glasso.setItr(parameters.getBoolean("itr"));
            glasso.setIpen(parameters.getBoolean("ipen"));
            glasso.setThr(parameters.getDouble("thr"));
            glasso.setRhoAllEqual(1.0);
            Glasso.Result result = glasso.search();
            Matrix wwi = new Matrix(result.getWwi().toArray());
            List<Node> variables = ds.getVariables();
            EdgeListGraph resultGraph = new EdgeListGraph(variables);
            for (int i = 0; i < variables.size(); ++i) {
                for (int j = i + 1; j < variables.size(); ++j) {
                    if (wwi.get(i, j) == 0.0 || wwi.get(i, j) == 0.0) continue;
                    resultGraph.addUndirectedEdge(variables.get(i), variables.get(j));
                }
            }
            return resultGraph;
        }
        Glasso algorithm = new Glasso();
        DataSet data = (DataSet)ds;
        GeneralResamplingTest search = new GeneralResamplingTest(data, algorithm, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        search.setParameters(parameters);
        search.setVerbose(parameters.getBoolean("verbose"));
        return search.search();
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        return GraphUtils.undirectedGraph(graph);
    }

    @Override
    public String getDescription() {
        return "GLASSO (Graphical LASSO)";
    }

    @Override
    public DataType getDataType() {
        return DataType.Mixed;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("maxit");
        params.add("ia");
        params.add("is");
        params.add("itr");
        params.add("ipen");
        params.add("thr");
        params.add("verbose");
        return params;
    }
}

