/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.comparegraphs;

import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.graph.Graph;
import java.util.List;

public class CompareTwoGraphs {
    private final Graph target;
    private final Graph reference;
    private List<Statistic> statistics;
    private CompareToType compareToType = CompareToType.DAG;
    private ComparisonType comparisontype = ComparisonType.STATS_LIST;

    public CompareTwoGraphs(Graph target, Graph reference) {
        this.target = target;
        this.reference = reference;
    }

    public void setCompareToType(CompareToType compareTo) {
        this.compareToType = compareTo;
    }

    public void setComparisontype(ComparisonType comparisontype) {
        this.comparisontype = comparisontype;
    }

    public void addStatistic(Statistic statistic) {
        this.statistics.add(statistic);
    }

    public String getComparisonString() {
        switch (this.comparisontype.ordinal()) {
            case 0: {
                return this.statsListString();
            }
            case 1: {
                return this.edgewiseString();
            }
            case 2: {
                return this.misclassificationsString();
            }
        }
        throw new IllegalStateException("Unsupported comparison type: " + (Object)((Object)this.comparisontype));
    }

    private String statsListString() {
        return "foo";
    }

    private String edgewiseString() {
        return "foo";
    }

    private String misclassificationsString() {
        return "foo";
    }

    public static enum CompareToType {
        DAG,
        CPDAG,
        PAG;

    }

    public static enum ComparisonType {
        STATS_LIST,
        EDGEWISE,
        MISCLASSIFICATTONS;

    }
}

