/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.examples;

import edu.cmu.tetrad.algcomparison.Comparison;
import edu.cmu.tetrad.algcomparison.algorithm.Algorithms;
import edu.cmu.tetrad.algcomparison.algorithm.oracle.pag.SvarFci;
import edu.cmu.tetrad.algcomparison.algorithm.oracle.pag.SvarGfci;
import edu.cmu.tetrad.algcomparison.graph.RandomForward;
import edu.cmu.tetrad.algcomparison.independence.FisherZ;
import edu.cmu.tetrad.algcomparison.score.SemBicScore;
import edu.cmu.tetrad.algcomparison.simulation.Simulations;
import edu.cmu.tetrad.algcomparison.simulation.TimeSeriesSemSimulation;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyPrecision;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyRecall;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadPrecision;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadRecall;
import edu.cmu.tetrad.algcomparison.statistic.ElapsedCpuTime;
import edu.cmu.tetrad.algcomparison.statistic.F1Adj;
import edu.cmu.tetrad.algcomparison.statistic.F1Arrow;
import edu.cmu.tetrad.algcomparison.statistic.MathewsCorrAdj;
import edu.cmu.tetrad.algcomparison.statistic.MathewsCorrArrow;
import edu.cmu.tetrad.algcomparison.statistic.Statistics;
import edu.cmu.tetrad.algcomparison.statistic.StructuralHammingDistance;
import edu.cmu.tetrad.util.Parameters;

public class ExampleCompareSimulationTimeSeries {
    public static void main(String ... args) {
        Parameters parameters = new Parameters();
        parameters.set("numRuns", (Object)10);
        parameters.set("numMeasures", (Object)10);
        parameters.set("avgDegree", (Object)4);
        parameters.set("sampleSize", (Object)500);
        parameters.set("alpha", 1.0E-4, 0.001, 0.01);
        Statistics statistics = new Statistics();
        statistics.add(new AdjacencyPrecision());
        statistics.add(new AdjacencyRecall());
        statistics.add(new ArrowheadPrecision());
        statistics.add(new ArrowheadRecall());
        statistics.add(new MathewsCorrAdj());
        statistics.add(new MathewsCorrArrow());
        statistics.add(new F1Adj());
        statistics.add(new F1Arrow());
        statistics.add(new StructuralHammingDistance());
        statistics.add(new ElapsedCpuTime());
        statistics.setWeight("AP", 1.0);
        statistics.setWeight("AR", 0.5);
        Algorithms algorithms = new Algorithms();
        algorithms.add(new SvarFci(new FisherZ()));
        algorithms.add(new SvarGfci(new FisherZ(), new SemBicScore()));
        Simulations simulations = new Simulations();
        simulations.add(new TimeSeriesSemSimulation(new RandomForward()));
        Comparison comparison = new Comparison();
        comparison.setSortByUtility(true);
        comparison.setShowUtilities(true);
        comparison.compareFromSimulations("comparison", simulations, algorithms, statistics, parameters);
    }
}

