/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.examples;

import edu.cmu.tetrad.algcomparison.algorithm.oracle.cpdag.Fas;
import edu.cmu.tetrad.algcomparison.independence.SemBicTest;
import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DoubleDataBox;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.Parameters;
import edu.pitt.dbmi.data.reader.DataColumn;
import edu.pitt.dbmi.data.reader.Delimiter;
import edu.pitt.dbmi.data.reader.tabular.ContinuousTabularData;
import edu.pitt.dbmi.data.reader.tabular.ContinuousTabularDatasetFileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;

public class RunKemmeren {
    public static void main(String ... args) {
        Path path = Paths.get("/home/bandrews/Desktop/Kemmeren/obs_data.txt", new String[0]);
        System.out.println("Loading Data");
        ContinuousTabularDatasetFileReader reader = new ContinuousTabularDatasetFileReader(path, Delimiter.TAB);
        try {
            ContinuousTabularData data = (ContinuousTabularData)reader.readInData();
            ArrayList<Node> variables = new ArrayList<Node>();
            for (DataColumn column : data.getDataColumns()) {
                ContinuousVariable node = new ContinuousVariable(column.getName());
                variables.add(node);
            }
            BoxDataSet dataSet = new BoxDataSet(new DoubleDataBox(data.getData()), variables);
            System.out.println("Generating Background Knowledge");
            Knowledge knowledge = new Knowledge(dataSet.getVariableNames());
            System.out.println("Running Search");
            Parameters parameters = new Parameters();
            parameters.set("penaltyDiscount", (Object)2);
            parameters.set("structurePrior", (Object)1);
            parameters.set("faithfulnessAssumed", (Object)true);
            parameters.set("symmetricFirstStep", (Object)false);
            parameters.set("maxDegree", (Object)-1);
            parameters.set("depth", (Object)1);
            parameters.set("sepsetsReturnEmptyIfNotFixed", (Object)true);
            parameters.set("verbose", (Object)true);
            SemBicTest test = new SemBicTest();
            Fas search = new Fas(test);
            search.setKnowledge(knowledge);
            Graph graph = search.search(dataSet, parameters);
            System.out.println("Writing Output");
            PrintWriter out = new PrintWriter("/home/bandrews/Desktop/out.txt");
            out.println(graph.toString());
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

