/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.examples;

import edu.cmu.tetrad.algcomparison.Comparison;
import edu.cmu.tetrad.algcomparison.algorithm.Algorithms;
import edu.cmu.tetrad.algcomparison.algorithm.oracle.cpdag.Fges;
import edu.cmu.tetrad.algcomparison.graph.RandomForward;
import edu.cmu.tetrad.algcomparison.score.ConditionalGaussianBicScore;
import edu.cmu.tetrad.algcomparison.score.DegenerateGaussianBicScore;
import edu.cmu.tetrad.algcomparison.simulation.ConditionalGaussianSimulation;
import edu.cmu.tetrad.algcomparison.simulation.LeeHastieSimulation;
import edu.cmu.tetrad.algcomparison.simulation.Simulations;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyPrecision;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyRecall;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadPrecision;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadRecall;
import edu.cmu.tetrad.algcomparison.statistic.ElapsedCpuTime;
import edu.cmu.tetrad.algcomparison.statistic.Statistics;
import edu.cmu.tetrad.util.Parameters;

public class TestDegenerateGaussian {
    public static void main(String ... args) {
        Parameters parameters = new Parameters();
        parameters.set("numRuns", (Object)3);
        parameters.set("numMeasures", (Object)100);
        parameters.set("avgDegree", 2, 4);
        parameters.set("maxDegree", (Object)100);
        parameters.set("numCategories", (Object)3);
        parameters.set("minCategories", (Object)2);
        parameters.set("maxCategories", (Object)4);
        parameters.set("differentGraphs", (Object)true);
        parameters.set("sampleSize", (Object)1000);
        parameters.set("percentDiscrete", (Object)50);
        parameters.set("penaltyDiscount", (Object)1);
        parameters.set("structurePrior", (Object)1);
        parameters.set("samplePrior", (Object)1);
        parameters.set("discretize", (Object)false);
        parameters.set("alpha", 0.01, 0.001, 1.0E-4);
        parameters.set("mgmParam1", (Object)0.2);
        parameters.set("mgmParam2", (Object)0.2);
        parameters.set("mgmParam3", (Object)0.2);
        parameters.set("verbose", (Object)false);
        Statistics statistics = new Statistics();
        statistics.add(new AdjacencyPrecision());
        statistics.add(new AdjacencyRecall());
        statistics.add(new ArrowheadPrecision());
        statistics.add(new ArrowheadRecall());
        statistics.add(new ElapsedCpuTime());
        Algorithms algorithms = new Algorithms();
        algorithms.add(new Fges(new ConditionalGaussianBicScore()));
        algorithms.add(new Fges(new DegenerateGaussianBicScore()));
        Simulations simulations = new Simulations();
        simulations.add(new ConditionalGaussianSimulation(new RandomForward()));
        simulations.add(new LeeHastieSimulation(new RandomForward()));
        Comparison comparison = new Comparison();
        comparison.setShowAlgorithmIndices(true);
        comparison.setShowSimulationIndices(true);
        comparison.setSortByUtility(false);
        comparison.setShowUtilities(false);
        comparison.compareFromSimulations("comparison", simulations, algorithms, statistics, parameters);
    }
}

