/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.independence;

import edu.cmu.tetrad.algcomparison.independence.IndependenceWrapper;
import edu.cmu.tetrad.annotation.Experimental;
import edu.cmu.tetrad.annotation.TestOfIndependence;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.score.BdeuScore;
import edu.cmu.tetrad.search.test.ScoreIndTest;
import edu.cmu.tetrad.util.Parameters;
import java.util.ArrayList;
import java.util.List;

@TestOfIndependence(name="BDeu Test", command="bdeu-test", dataType={DataType.Discrete})
@Experimental
public class BdeuTest
implements IndependenceWrapper {
    private static final long serialVersionUID = 23L;

    @Override
    public IndependenceTest getTest(DataModel dataSet, Parameters parameters) {
        BdeuScore score = new BdeuScore(SimpleDataLoader.getDiscreteDataSet(dataSet));
        score.setSamplePrior(parameters.getDouble("priorEquivalentSampleSize"));
        score.setStructurePrior(parameters.getDouble("structurePrior"));
        return new ScoreIndTest(score);
    }

    @Override
    public String getDescription() {
        return "BDeu Test";
    }

    @Override
    public DataType getDataType() {
        return DataType.Discrete;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("priorEquivalentSampleSize");
        parameters.add("structurePrior");
        return parameters;
    }
}

