/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.independence;

import edu.cmu.tetrad.algcomparison.independence.IndependenceWrapper;
import edu.cmu.tetrad.annotation.General;
import edu.cmu.tetrad.annotation.TestOfIndependence;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.util.Parameters;
import java.util.ArrayList;
import java.util.List;

@TestOfIndependence(name="KCI-Test (Kernel Conditional Independence Test)", command="kci-test", dataType={DataType.Continuous})
@General
public class Kci
implements IndependenceWrapper {
    private static final long serialVersionUID = 23L;

    @Override
    public IndependenceTest getTest(DataModel dataSet, Parameters parameters) {
        edu.cmu.tetrad.search.test.Kci kci = new edu.cmu.tetrad.search.test.Kci(SimpleDataLoader.getContinuousDataSet(dataSet), parameters.getDouble("alpha"));
        kci.setApproximate(parameters.getBoolean("kciUseAppromation"));
        kci.setWidthMultiplier(parameters.getDouble("kernelMultiplier"));
        kci.setNumBootstraps(parameters.getInt("kciNumBootstraps"));
        kci.setThreshold(parameters.getDouble("thresholdForNumEigenvalues"));
        kci.setEpsilon(parameters.getDouble("kciEpsilon"));
        return kci;
    }

    @Override
    public String getDescription() {
        return "KCI";
    }

    @Override
    public DataType getDataType() {
        return DataType.Continuous;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("kciUseAppromation");
        params.add("alpha");
        params.add("kernelMultiplier");
        params.add("kciNumBootstraps");
        params.add("thresholdForNumEigenvalues");
        params.add("kciEpsilon");
        return params;
    }
}

