/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.independence;

import edu.cmu.tetrad.algcomparison.independence.IndependenceWrapper;
import edu.cmu.tetrad.annotation.LinearGaussian;
import edu.cmu.tetrad.annotation.TestOfIndependence;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.test.ScoreIndTest;
import edu.cmu.tetrad.search.work_in_progress.MagSemBicScore;
import edu.cmu.tetrad.util.Parameters;
import java.util.ArrayList;
import java.util.List;

@TestOfIndependence(name="MAG SEM BIC Test", command="mag-sem-bic-test", dataType={DataType.Continuous, DataType.Covariance})
@LinearGaussian
public class MagSemBicTest
implements IndependenceWrapper {
    private static final long serialVersionUID = 23L;

    @Override
    public IndependenceTest getTest(DataModel dataSet, Parameters parameters) {
        boolean precomputeCovariances = parameters.getBoolean("precomputeCovariances");
        MagSemBicScore score = dataSet instanceof ICovarianceMatrix ? new MagSemBicScore((ICovarianceMatrix)dataSet) : new MagSemBicScore((DataSet)dataSet, precomputeCovariances);
        score.setPenaltyDiscount(parameters.getDouble("penaltyDiscount"));
        return new ScoreIndTest(score, dataSet);
    }

    @Override
    public String getDescription() {
        return "SEM BIC Test";
    }

    @Override
    public DataType getDataType() {
        return DataType.Continuous;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("penaltyDiscount");
        params.add("structurePrior");
        params.add("precomputeCovariances");
        return params;
    }
}

