/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.independence;

import edu.cmu.tetrad.algcomparison.independence.IndependenceWrapper;
import edu.cmu.tetrad.annotation.Experimental;
import edu.cmu.tetrad.annotation.TestOfIndependence;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.work_in_progress.IndTestMnlrLr;
import edu.cmu.tetrad.util.Parameters;
import java.util.ArrayList;
import java.util.List;

@Experimental
@TestOfIndependence(name="Multinomial Logistic Regression Likelihood Ratio Test", command="mnlrlr-test", dataType={DataType.Mixed})
public class Mnlrlrt
implements IndependenceWrapper {
    private static final long serialVersionUID = 23L;

    @Override
    public IndependenceTest getTest(DataModel dataSet, Parameters parameters) {
        return new IndTestMnlrLr(SimpleDataLoader.getMixedDataSet(dataSet), parameters.getDouble("alpha"));
    }

    @Override
    public String getDescription() {
        return "Mixed Variable Polynomial Likelihood Ratio Test";
    }

    @Override
    public DataType getDataType() {
        return DataType.Mixed;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("alpha");
        return parameters;
    }
}

