/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.independence;

import edu.cmu.tetrad.algcomparison.independence.IndependenceWrapper;
import edu.cmu.tetrad.annotation.LinearGaussian;
import edu.cmu.tetrad.annotation.TestOfIndependence;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.score.PoissonPriorScore;
import edu.cmu.tetrad.search.test.ScoreIndTest;
import edu.cmu.tetrad.util.Parameters;
import java.util.ArrayList;
import java.util.List;

@TestOfIndependence(name="Poisson Prior Test", command="poisson-prior-test", dataType={DataType.Continuous, DataType.Covariance})
@LinearGaussian
public class PoissonScoreTest
implements IndependenceWrapper {
    private static final long serialVersionUID = 23L;

    @Override
    public IndependenceTest getTest(DataModel dataSet, Parameters parameters) {
        PoissonPriorScore score = dataSet instanceof ICovarianceMatrix ? new PoissonPriorScore((ICovarianceMatrix)dataSet) : new PoissonPriorScore((DataSet)dataSet, true);
        score.setLambda(parameters.getDouble("poissonLambda"));
        return new ScoreIndTest(score, dataSet);
    }

    @Override
    public String getDescription() {
        return "Poisson Prior Test";
    }

    @Override
    public DataType getDataType() {
        return DataType.Continuous;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("poissonLambda");
        return params;
    }
}

