/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.independence;

import edu.cmu.tetrad.algcomparison.independence.IndependenceWrapper;
import edu.cmu.tetrad.annotation.TestOfIndependence;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.test.IndTestProbabilistic;
import edu.cmu.tetrad.util.Parameters;
import java.util.ArrayList;
import java.util.List;

@TestOfIndependence(name="Probabilistic Test", command="prob-test", dataType={DataType.Discrete})
public class ProbabilisticTest
implements IndependenceWrapper {
    private static final long serialVersionUID = 23L;

    @Override
    public IndependenceTest getTest(DataModel dataSet, Parameters parameters) {
        IndTestProbabilistic test = new IndTestProbabilistic(SimpleDataLoader.getDiscreteDataSet(dataSet));
        test.setThreshold(parameters.getBoolean("noRandomlyDeterminedIndependence"));
        test.setCutoff(parameters.getDouble("cutoffIndTest"));
        test.setPriorEquivalentSampleSize(parameters.getDouble("priorEquivalentSampleSize"));
        return test;
    }

    @Override
    public String getDescription() {
        return "Probabilistic Conditional Independence Test";
    }

    @Override
    public DataType getDataType() {
        return DataType.Discrete;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("noRandomlyDeterminedIndependence");
        parameters.add("cutoffIndTest");
        parameters.add("priorEquivalentSampleSize");
        return parameters;
    }
}

