/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.score;

import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.annotation.Mixed;
import edu.cmu.tetrad.annotation.Score;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.score.ConditionalGaussianScore;
import edu.cmu.tetrad.util.Parameters;
import java.util.ArrayList;
import java.util.List;

@Score(name="CG-BIC (Conditional Gaussian BIC Score)", command="cg-bic-score", dataType={DataType.Mixed})
@Mixed
public class ConditionalGaussianBicScore
implements ScoreWrapper {
    private static final long serialVersionUID = 23L;
    private DataModel dataSet;

    @Override
    public edu.cmu.tetrad.search.score.Score getScore(DataModel dataSet, Parameters parameters) {
        this.dataSet = dataSet;
        ConditionalGaussianScore conditionalGaussianScore = new ConditionalGaussianScore(SimpleDataLoader.getMixedDataSet(dataSet), parameters.getDouble("penaltyDiscount"), parameters.getBoolean("discretize"));
        conditionalGaussianScore.setNumCategoriesToDiscretize(parameters.getInt("numCategoriesToDiscretize"));
        conditionalGaussianScore.setStructurePrior(parameters.getDouble("structurePrior"));
        return conditionalGaussianScore;
    }

    @Override
    public String getDescription() {
        return "Conditional Gaussian BIC Score";
    }

    @Override
    public DataType getDataType() {
        return DataType.Mixed;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("penaltyDiscount");
        parameters.add("structurePrior");
        parameters.add("discretize");
        parameters.add("numCategoriesToDiscretize");
        return parameters;
    }

    @Override
    public Node getVariable(String name) {
        return this.dataSet.getVariable(name);
    }
}

