/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.score;

import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.annotation.Mixed;
import edu.cmu.tetrad.annotation.Score;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.score.DegenerateGaussianScore;
import edu.cmu.tetrad.util.Parameters;
import java.util.ArrayList;
import java.util.List;

@Score(name="DG-BIC (Degenerate Gaussian BIC Score)", command="dg-bic-score", dataType={DataType.Mixed})
@Mixed
public class DegenerateGaussianBicScore
implements ScoreWrapper {
    private static final long serialVersionUID = 23L;
    private DataModel dataSet;

    @Override
    public edu.cmu.tetrad.search.score.Score getScore(DataModel dataSet, Parameters parameters) {
        this.dataSet = dataSet;
        boolean precomputeCovariances = parameters.getBoolean("precomputeCovariances");
        DegenerateGaussianScore degenerateGaussianScore = new DegenerateGaussianScore(SimpleDataLoader.getMixedDataSet(dataSet), precomputeCovariances);
        degenerateGaussianScore.setPenaltyDiscount(parameters.getDouble("penaltyDiscount"));
        return degenerateGaussianScore;
    }

    @Override
    public String getDescription() {
        return "Degenerate Gaussian BIC Score";
    }

    @Override
    public DataType getDataType() {
        return DataType.Mixed;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("penaltyDiscount");
        parameters.add("structurePrior");
        parameters.add("precomputeCovariances");
        return parameters;
    }

    @Override
    public Node getVariable(String name) {
        return this.dataSet.getVariable(name);
    }
}

