/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.score;

import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.annotation.Score;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.Parameters;
import java.util.ArrayList;
import java.util.List;

@Score(name="Discrete BIC Score", command="disc-bic-score", dataType={DataType.Discrete})
public class DiscreteBicScore
implements ScoreWrapper {
    private static final long serialVersionUID = 23L;
    private DataModel dataSet;

    @Override
    public edu.cmu.tetrad.search.score.Score getScore(DataModel dataSet, Parameters parameters) {
        this.dataSet = dataSet;
        edu.cmu.tetrad.search.score.DiscreteBicScore score = new edu.cmu.tetrad.search.score.DiscreteBicScore(SimpleDataLoader.getDiscreteDataSet(dataSet));
        score.setPenaltyDiscount(parameters.getDouble("penaltyDiscount"));
        score.setStructurePrior(parameters.getDouble("structurePrior"));
        return score;
    }

    @Override
    public String getDescription() {
        return "Discrete BIC Score";
    }

    @Override
    public DataType getDataType() {
        return DataType.Discrete;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("penaltyDiscount");
        params.add("structurePrior");
        return params;
    }

    @Override
    public Node getVariable(String name) {
        return this.dataSet.getVariable(name);
    }
}

