/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.score;

import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.annotation.LinearGaussian;
import edu.cmu.tetrad.annotation.Score;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.score.GicScores;
import edu.cmu.tetrad.util.Parameters;
import java.util.ArrayList;
import java.util.List;

@Score(name="Generalied Information Criterion Scores", command="gic-scores", dataType={DataType.Continuous, DataType.Covariance})
@LinearGaussian
public class GicScores
implements ScoreWrapper {
    private static final long serialVersionUID = 23L;
    private DataModel dataSet;

    @Override
    public edu.cmu.tetrad.search.score.Score getScore(DataModel dataSet, Parameters parameters) {
        GicScores.RuleType ruleType;
        edu.cmu.tetrad.search.score.GicScores score;
        this.dataSet = dataSet;
        boolean precomputeCovariances = parameters.getBoolean("precomputeCovariances");
        if (dataSet instanceof DataSet) {
            score = new edu.cmu.tetrad.search.score.GicScores((DataSet)this.dataSet, precomputeCovariances);
        } else if (dataSet instanceof ICovarianceMatrix) {
            score = new edu.cmu.tetrad.search.score.GicScores((ICovarianceMatrix)this.dataSet);
        } else {
            throw new IllegalArgumentException("Expecting either a dataset or a covariance matrix.");
        }
        int anInt = parameters.getInt("semGicRule");
        switch (anInt) {
            case 1: {
                ruleType = GicScores.RuleType.BIC;
                break;
            }
            case 2: {
                ruleType = GicScores.RuleType.GIC2;
                break;
            }
            case 3: {
                ruleType = GicScores.RuleType.RIC;
                break;
            }
            case 4: {
                ruleType = GicScores.RuleType.RICc;
                break;
            }
            case 5: {
                ruleType = GicScores.RuleType.GIC5;
                break;
            }
            case 6: {
                ruleType = GicScores.RuleType.GIC6;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized rule type: " + anInt);
            }
        }
        score.setRuleType(ruleType);
        score.setPenaltyDiscount(parameters.getDouble("penaltyDiscount"));
        return score;
    }

    @Override
    public String getDescription() {
        return "Generalized Information Criterion Scores";
    }

    @Override
    public DataType getDataType() {
        return DataType.Continuous;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("semGicRule");
        parameters.add("penaltyDiscountZs");
        parameters.add("precomputeCovariances");
        return parameters;
    }

    @Override
    public Node getVariable(String name) {
        return this.dataSet.getVariable(name);
    }
}

