/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.score;

import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.annotation.Experimental;
import edu.cmu.tetrad.annotation.Score;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.score.MvpScore;
import edu.cmu.tetrad.util.Parameters;
import java.util.ArrayList;
import java.util.List;

@Experimental
@Score(name="Mixed Variable Polynomial BIC Score", command="mvp-bic-score", dataType={DataType.Mixed})
public class MVPBicScore
implements ScoreWrapper {
    private static final long serialVersionUID = 23L;

    @Override
    public edu.cmu.tetrad.search.score.Score getScore(DataModel dataSet, Parameters parameters) {
        return new MvpScore(SimpleDataLoader.getMixedDataSet(dataSet), parameters.getDouble("structurePrior", 0.0), parameters.getInt("fDegree", -1), parameters.getInt("discretize", 0) > 0);
    }

    @Override
    public String getDescription() {
        return "Mixed Variable Polynomial BIC Score";
    }

    @Override
    public DataType getDataType() {
        return DataType.Mixed;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("structurePrior");
        parameters.add("fDegree");
        parameters.add("discretize");
        return parameters;
    }

    @Override
    public Node getVariable(String name) {
        return null;
    }
}

