/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.score;

import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.annotation.Score;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.Parameters;
import java.util.ArrayList;
import java.util.List;

@Score(name="MAG SEM BIC Score", command="mag-sem-bic-score", dataType={DataType.Continuous, DataType.Covariance})
public class MagSemBicScore
implements ScoreWrapper {
    private static final long serialVersionUID = 23L;
    private DataModel dataSet;

    @Override
    public edu.cmu.tetrad.search.score.Score getScore(DataModel dataSet, Parameters parameters) {
        edu.cmu.tetrad.search.work_in_progress.MagSemBicScore semBicScore;
        this.dataSet = dataSet;
        boolean precomputeCovariances = parameters.getBoolean("precomputeCovariances");
        if (dataSet instanceof DataSet) {
            semBicScore = new edu.cmu.tetrad.search.work_in_progress.MagSemBicScore((DataSet)this.dataSet, precomputeCovariances);
        } else if (dataSet instanceof ICovarianceMatrix) {
            semBicScore = new edu.cmu.tetrad.search.work_in_progress.MagSemBicScore((ICovarianceMatrix)this.dataSet);
        } else {
            throw new IllegalArgumentException("Expecting either a dataset or a covariance matrix.");
        }
        semBicScore.setPenaltyDiscount(parameters.getDouble("penaltyDiscount"));
        return semBicScore;
    }

    @Override
    public String getDescription() {
        return "MAG SEM BIC Score";
    }

    @Override
    public DataType getDataType() {
        return DataType.Continuous;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("penaltyDiscount");
        parameters.add("semBicStructurePrior");
        parameters.add("semBicRule");
        parameters.add("precomputeCovariances");
        return parameters;
    }

    @Override
    public Node getVariable(String name) {
        return this.dataSet.getVariable(name);
    }
}

