/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.score;

import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.annotation.LinearGaussian;
import edu.cmu.tetrad.annotation.Score;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.score.ZsbScore;
import edu.cmu.tetrad.util.Parameters;
import java.util.ArrayList;
import java.util.List;

@Score(name="ZS Bound Score", command="zsbound-score", dataType={DataType.Continuous, DataType.Covariance})
@LinearGaussian
public class ZhangShenBoundScore
implements ScoreWrapper {
    private static final long serialVersionUID = 23L;
    private DataModel dataSet;

    @Override
    public edu.cmu.tetrad.search.score.Score getScore(DataModel dataSet, Parameters parameters) {
        ZsbScore score;
        this.dataSet = dataSet;
        boolean precomputeCovariances = parameters.getBoolean("precomputeCovariances");
        if (dataSet instanceof DataSet) {
            score = new ZsbScore((DataSet)this.dataSet, precomputeCovariances);
        } else if (dataSet instanceof ICovarianceMatrix) {
            score = new ZsbScore((ICovarianceMatrix)this.dataSet);
        } else {
            throw new IllegalArgumentException("Expecting either a dataset or a covariance matrix.");
        }
        score.setRiskBound(parameters.getDouble("zSRiskBound"));
        return score;
    }

    @Override
    public String getDescription() {
        return "Zhang-Shen Bound Score";
    }

    @Override
    public DataType getDataType() {
        return DataType.Continuous;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("zSRiskBound");
        parameters.add("precomputeCovariances");
        return parameters;
    }

    @Override
    public Node getVariable(String name) {
        return this.dataSet.getVariable(name);
    }
}

