/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.simulation;

import edu.cmu.tetrad.algcomparison.graph.RandomGraph;
import edu.cmu.tetrad.algcomparison.simulation.Simulation;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataTransforms;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.sem.GeneralizedSemIm;
import edu.cmu.tetrad.sem.GeneralizedSemPm;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.RandomUtil;
import edu.pitt.csb.mgm.MixedUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class LeeHastieSimulation
implements Simulation {
    private static final long serialVersionUID = 23L;
    private final RandomGraph randomGraph;
    private List<DataSet> dataSets = new ArrayList<DataSet>();
    private List<Graph> graphs = new ArrayList<Graph>();
    private DataType dataType;
    private List<Node> shuffledOrder;

    public LeeHastieSimulation(RandomGraph graph) {
        this.randomGraph = graph;
    }

    @Override
    public void createData(Parameters parameters, boolean newModel) {
        double percentDiscrete = parameters.getDouble("percentDiscrete");
        boolean discrete = parameters.getString("dataType").equals("discrete");
        boolean continuous = parameters.getString("dataType").equals("continuous");
        if (discrete && percentDiscrete != 100.0) {
            throw new IllegalArgumentException("To simulate discrete data, 'percentDiscrete' must be set to 0.0.");
        }
        if (continuous && percentDiscrete != 0.0) {
            throw new IllegalArgumentException("To simulate continuoue data, 'percentDiscrete' must be set to 100.0.");
        }
        if (discrete) {
            this.dataType = DataType.Discrete;
        }
        if (continuous) {
            this.dataType = DataType.Continuous;
        }
        this.shuffledOrder = null;
        Graph graph = this.randomGraph.createGraph(parameters);
        this.dataSets = new ArrayList<DataSet>();
        this.graphs = new ArrayList<Graph>();
        for (int i = 0; i < parameters.getInt("numRuns"); ++i) {
            System.out.println("Simulating dataset #" + (i + 1));
            if (parameters.getBoolean("differentGraphs") && i > 0) {
                graph = this.randomGraph.createGraph(parameters);
            }
            this.graphs.add(graph);
            DataSet dataSet = this.simulate(graph, parameters);
            dataSet.setName("" + (i + 1));
            if (parameters.getBoolean("randomizeColumns")) {
                dataSet = DataTransforms.shuffleColumns(dataSet);
            }
            if (parameters.getDouble("probRemoveColumn") > 0.0) {
                double aDouble = parameters.getDouble("probRemoveColumn");
                dataSet = DataTransforms.removeRandomColumns(dataSet, aDouble);
            }
            this.dataSets.add(dataSet);
        }
    }

    @Override
    public Graph getTrueGraph(int index) {
        return this.graphs.get(index);
    }

    @Override
    public DataModel getDataModel(int index) {
        return this.dataSets.get(index);
    }

    @Override
    public String getDescription() {
        return "Lee & Hastie simulation using " + this.randomGraph.getDescription();
    }

    @Override
    public List<String> getParameters() {
        List<String> parameters = this.randomGraph.getParameters();
        parameters.add("minCategories");
        parameters.add("maxCategories");
        parameters.add("percentDiscrete");
        parameters.add("numRuns");
        parameters.add("probRemoveColumn");
        parameters.add("differentGraphs");
        parameters.add("randomizeColumns");
        parameters.add("sampleSize");
        parameters.add("saveLatentVars");
        parameters.add("verbose");
        return parameters;
    }

    @Override
    public int getNumDataModels() {
        return this.dataSets.size();
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    private DataSet simulate(Graph dag, Parameters parameters) {
        HashMap<String, Integer> nd = new HashMap<String, Integer>();
        List<Node> nodes = dag.getNodes();
        ArrayList<Node> shuffledNodes = new ArrayList<Node>(nodes);
        RandomUtil.shuffle(shuffledNodes);
        if (this.shuffledOrder == null) {
            this.shuffledOrder = shuffledNodes;
        }
        for (int i = 0; i < this.shuffledOrder.size(); ++i) {
            if ((double)i < (double)this.shuffledOrder.size() * parameters.getDouble("percentDiscrete") * 0.01) {
                int minNumCategories = parameters.getInt("minCategories");
                int maxNumCategories = parameters.getInt("maxCategories");
                int value = this.pickNumCategories(minNumCategories, maxNumCategories);
                nd.put(this.shuffledOrder.get(i).getName(), value);
                continue;
            }
            nd.put(this.shuffledOrder.get(i).getName(), 0);
        }
        Graph graph = MixedUtils.makeMixedGraph(dag, nd);
        GeneralizedSemPm pm = MixedUtils.GaussianCategoricalPm(graph, "Split(-1.0,-.0,.0,1.0)");
        GeneralizedSemIm im = MixedUtils.GaussianCategoricalIm(pm);
        boolean saveLatentVars = parameters.getBoolean("saveLatentVars");
        DataSet ds = im.simulateDataAvoidInfinity(parameters.getInt("sampleSize"), saveLatentVars);
        return MixedUtils.makeMixedData(ds, nd);
    }

    private int pickNumCategories(int min, int max) {
        return min + RandomUtil.getInstance().nextInt(max - min + 1);
    }
}

