/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.simulation;

import edu.cmu.tetrad.algcomparison.graph.RandomGraph;
import edu.cmu.tetrad.algcomparison.simulation.Simulation;
import edu.cmu.tetrad.algcomparison.utils.TakesData;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataTransforms;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.sem.LargeScaleSimulation;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.RandomUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.commons.math3.util.FastMath;

public class LinearFisherModel
implements Simulation,
TakesData {
    private static final long serialVersionUID = 23L;
    private final RandomGraph randomGraph;
    private final List<DataModel> shocks;
    private List<DataSet> dataSets = new ArrayList<DataSet>();
    private List<Graph> graphs = new ArrayList<Graph>();

    public LinearFisherModel(RandomGraph graph) {
        this.randomGraph = graph;
        this.shocks = null;
    }

    public LinearFisherModel(RandomGraph graph, List<DataModel> shocks) {
        this.randomGraph = graph;
        this.shocks = shocks;
        if (shocks != null) {
            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "The initial dataset you've provided will be used as initial shocks\nfor a Fisher model.");
            for (DataModel _shocks : shocks) {
                if (_shocks == null) {
                    throw new NullPointerException("Dataset containing shocks must not be null.");
                }
                DataSet dataSet = (DataSet)_shocks;
                if (dataSet.isContinuous()) continue;
                throw new IllegalArgumentException("Dataset containing shocks must be continuous tabular.");
            }
        }
    }

    @Override
    public void createData(Parameters parameters, boolean newModel) {
        boolean saveLatentVars = parameters.getBoolean("saveLatentVars");
        this.dataSets = new ArrayList<DataSet>();
        this.graphs = new ArrayList<Graph>();
        Graph graph = this.randomGraph.createGraph(parameters);
        System.out.println("degree = " + GraphUtils.getDegree(graph));
        for (int i = 0; i < parameters.getInt("numRuns"); ++i) {
            DataSet dataSet;
            System.out.println("Simulating dataset #" + (i + 1));
            if (this.shocks != null && this.shocks.size() > 0) {
                parameters.set("numMeasures", (Object)this.shocks.get(0).getVariables().size());
            }
            if (parameters.getBoolean("differentGraphs") && i > 0) {
                graph = this.randomGraph.createGraph(parameters);
            }
            if (this.shocks != null && this.shocks.size() > 0) {
                graph.setNodes(this.shocks.get(0).getVariables());
            }
            this.graphs.add(graph);
            int[] tiers = new int[graph.getNodes().size()];
            for (int j = 0; j < tiers.length; ++j) {
                tiers[j] = j;
            }
            LargeScaleSimulation simulator = new LargeScaleSimulation(graph, graph.getNodes(), tiers);
            simulator.setCoefRange(parameters.getDouble("coefLow"), parameters.getDouble("coefHigh"));
            simulator.setVarRange(parameters.getDouble("varLow"), parameters.getDouble("varHigh"));
            simulator.setIncludePositiveCoefs(parameters.getBoolean("includePositiveCoefs"));
            simulator.setIncludeNegativeCoefs(parameters.getBoolean("includeNegativeCoefs"));
            simulator.setSelfLoopCoef(parameters.getDouble("selfLoopCoef"));
            simulator.setMeanRange(parameters.getDouble("meanLow"), parameters.getDouble("meanHigh"));
            simulator.setErrorsNormal(parameters.getBoolean("errorsNormal"));
            simulator.setVerbose(parameters.getBoolean("verbose"));
            if (this.shocks == null) {
                dataSet = simulator.simulateDataFisher(parameters.getInt("intervalBetweenShocks"), parameters.getInt("intervalBetweenRecordings"), parameters.getInt("sampleSize"), parameters.getDouble("fisherEpsilon"), saveLatentVars);
            } else {
                DataSet _shocks = (DataSet)this.shocks.get(i);
                dataSet = simulator.simulateDataFisher(_shocks.getDoubleData().toArray(), parameters.getInt("intervalBetweenShocks"), parameters.getDouble("fisherEpsilon"));
            }
            double variance = parameters.getDouble("measurementVariance");
            if (variance > 0.0) {
                for (int k = 0; k < dataSet.getNumRows(); ++k) {
                    for (int j = 0; j < dataSet.getNumColumns(); ++j) {
                        double d = dataSet.getDouble(k, j);
                        double delta = RandomUtil.getInstance().nextNormal(0.0, FastMath.sqrt(variance));
                        dataSet.setDouble(k, j, d + delta);
                    }
                }
            }
            dataSet.setName("" + (i + 1));
            if (parameters.getBoolean("standardize")) {
                dataSet = DataTransforms.standardizeData(dataSet);
            }
            if (parameters.getBoolean("randomizeColumns")) {
                dataSet = DataTransforms.shuffleColumns(dataSet);
            }
            if (parameters.getDouble("probRemoveColumn") > 0.0) {
                double aDouble = parameters.getDouble("probRemoveColumn");
                dataSet = DataTransforms.removeRandomColumns(dataSet, aDouble);
            }
            this.dataSets.add(saveLatentVars ? dataSet : DataTransforms.restrictToMeasured(dataSet));
        }
    }

    @Override
    public DataModel getDataModel(int index) {
        return this.dataSets.get(index);
    }

    @Override
    public Graph getTrueGraph(int index) {
        return this.graphs.get(index);
    }

    @Override
    public String getDescription() {
        return "Linear Fisher model simulation";
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>(this.randomGraph.getParameters());
        if (this.shocks != null) {
            parameters.remove("numMeasures");
            parameters.remove("numLatents");
        }
        parameters.add("coefLow");
        parameters.add("coefHigh");
        parameters.add("varLow");
        parameters.add("varHigh");
        parameters.add("verbose");
        parameters.add("includePositiveCoefs");
        parameters.add("includeNegativeCoefs");
        parameters.add("errorsNormal");
        parameters.add("numRuns");
        parameters.add("probRemoveColumn");
        parameters.add("numCategories");
        parameters.add("differentGraphs");
        parameters.add("sampleSize");
        parameters.add("intervalBetweenShocks");
        parameters.add("intervalBetweenRecordings");
        parameters.add("selfLoopCoef");
        parameters.add("fisherEpsilon");
        parameters.add("randomizeColumns");
        parameters.add("measurementVariance");
        parameters.add("saveLatentVars");
        parameters.add("standardize");
        return parameters;
    }

    @Override
    public int getNumDataModels() {
        return this.dataSets.size();
    }

    @Override
    public DataType getDataType() {
        return DataType.Continuous;
    }
}

