/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import java.util.List;

public class AncestralRecall
implements Statistic {
    private static final long serialVersionUID = 23L;

    @Override
    public String getAbbreviation() {
        return "AncR";
    }

    @Override
    public String getDescription() {
        return "Proportion of X~~>Y in true for which X~~>Y in est";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        int tp = 0;
        int fn = 0;
        List<Node> nodes = trueGraph.getNodes();
        for (Node x : nodes) {
            for (Node y : nodes) {
                if (x == y || !trueGraph.paths().isAncestorOf(x, y)) continue;
                if (estGraph.paths().isAncestorOf(x, y)) {
                    ++tp;
                    continue;
                }
                ++fn;
            }
        }
        return (double)tp / (double)(tp + fn);
    }

    @Override
    public double getNormValue(double value) {
        return value;
    }
}

