/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphTransforms;

public class BidirectedRecall
implements Statistic {
    private static final long serialVersionUID = 23L;

    @Override
    public String getAbbreviation() {
        return "PBR";
    }

    @Override
    public String getDescription() {
        return "Recall of bidirected edges compared to the true PAG";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        Graph pag = GraphTransforms.dagToPag(trueGraph);
        int tp = 0;
        int fn = 0;
        for (Edge edge : pag.getEdges()) {
            if (!Edges.isBidirectedEdge(edge)) continue;
            Edge edge2 = estGraph.getEdge(edge.getNode1(), edge.getNode2());
            if (edge2 != null && Edges.isBidirectedEdge(edge2)) {
                ++tp;
                continue;
            }
            ++fn;
        }
        return (double)tp / (double)(tp + fn);
    }

    @Override
    public double getNormValue(double value) {
        return value;
    }
}

