/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphTransforms;

public class BidirectedTrue
implements Statistic {
    private static final long serialVersionUID = 23L;

    @Override
    public String getAbbreviation() {
        return "BT";
    }

    @Override
    public String getDescription() {
        return "Number of estimated bidirected edges";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        Graph pag = GraphTransforms.dagToPag(trueGraph);
        int t = 0;
        for (Edge edge : pag.getEdges()) {
            if (!Edges.isBidirectedEdge(edge)) continue;
            ++t;
        }
        System.out.println("True # bidirected edges = " + t);
        return t;
    }

    @Override
    public double getNormValue(double value) {
        return value;
    }
}

