/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.CommonAncestorTruePositiveBidirected;
import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;

public class CommonAncestorFalsePositiveBidirected
implements Statistic {
    private static final long serialVersionUID = 23L;

    @Override
    public String getAbbreviation() {
        return "CAFPB";
    }

    @Override
    public String getDescription() {
        return "Common Ancestor False Positive Bidirected";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        int fp = 0;
        for (Edge edge : estGraph.getEdges()) {
            if (!Edges.isBidirectedEdge(edge) || CommonAncestorTruePositiveBidirected.existsCommonAncestor(trueGraph, edge)) continue;
            ++fp;
        }
        return fp;
    }

    @Override
    public double getNormValue(double value) {
        return value;
    }
}

