/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.algcomparison.statistic.utils.AdjacencyConfusion;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Graph;

public class F1Adj
implements Statistic {
    private static final long serialVersionUID = 23L;

    @Override
    public String getAbbreviation() {
        return "F1Adj";
    }

    @Override
    public String getDescription() {
        return "F1 statistic for adjacencies";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        AdjacencyConfusion adjConfusion = new AdjacencyConfusion(trueGraph, estGraph);
        int adjTp = adjConfusion.getTp();
        int adjFp = adjConfusion.getFp();
        int adjFn = adjConfusion.getFn();
        int adjTn = adjConfusion.getTn();
        double adjPrecision = (double)adjTp / (double)(adjTp + adjFp);
        double adjRecall = (double)adjTp / (double)(adjTp + adjFn);
        return 2.0 * (adjPrecision * adjRecall) / (adjPrecision + adjRecall);
    }

    @Override
    public double getNormValue(double value) {
        return value;
    }
}

