/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import java.util.List;

public class FalsePositiveAdjacencies
implements Statistic {
    private static final long serialVersionUID = 23L;

    @Override
    public String getAbbreviation() {
        return "FP-Adj";
    }

    @Override
    public String getDescription() {
        return "False Positives Adjacencies";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        int fp = 0;
        List<Node> nodes = trueGraph.getNodes();
        for (int i = 0; i < nodes.size(); ++i) {
            for (int j = i + 1; j < nodes.size(); ++j) {
                Node y;
                Node x = nodes.get(i);
                if (!estGraph.isAdjacentTo(x, y = nodes.get(j)) || trueGraph.isAdjacentTo(x, y)) continue;
                ++fp;
            }
        }
        return fp;
    }

    @Override
    public double getNormValue(double value) {
        return value;
    }
}

