/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.ConditioningSetType;
import edu.cmu.tetrad.search.MarkovCheck;
import edu.cmu.tetrad.search.test.IndTestFisherZ;

public class FractionDependentUnderAlternative
implements Statistic {
    private static final long serialVersionUID = 23L;
    private double alpha = 0.01;

    public FractionDependentUnderAlternative() {
    }

    public FractionDependentUnderAlternative(double alpha) {
        this.alpha = alpha;
    }

    @Override
    public String getAbbreviation() {
        return "DA";
    }

    @Override
    public String getDescription() {
        return "Fraction P-values Dependent Under the Alternative (depends only on the estimated DAG and the data)";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        MarkovCheck markovCheck = new MarkovCheck(estGraph, new IndTestFisherZ((DataSet)dataModel, this.alpha), ConditioningSetType.LOCAL_MARKOV);
        markovCheck.generateResults();
        return markovCheck.getFractionDependent(false);
    }

    @Override
    public double getNormValue(double value) {
        return value;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }
}

